<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('defectos_procedimiento_produccion', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('defecto_id');
            $table->unsignedBigInteger('procedimiento_proceso_id');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('defecto_id')->references('id')->on('defectos_produccion');
            $table->foreign('procedimiento_proceso_id')->references('id')->on('procedimientos_proceso_produccion');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('defectos_procedimiento_produccion');
    }
};
