<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('procesos_produccion', function (Blueprint $table) {
            $table->id();
            $table->string('descripcion');
            $table->integer('meta');
            $table->unsignedBigInteger('estilo_id');
            $table->unsignedBigInteger('linea_id');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('estilo_id')->references('id')->on('estilos_produccion');
            $table->foreign('linea_id')->references('id')->on('lineas_produccion'); 
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('procesos_produccion');
    }
};
