<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Proceso extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'procesos_produccion';

    protected $fillable = [
        'descripcion',
        'meta',
        'linea_id',
        'estilo_id',
    ];

    public function linea()
    {
        return $this->belongsTo(Linea::class, 'linea_id');
    }

    public function estilo()
    {
        return $this->belongsTo(Estilo::class, 'estilo_id');
    }

    public function procedimientosProceso()
    {
        return $this->hasMany(ProcedimientoProceso::class, 'proceso_id');
    }
}
