<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProcedimientoProceso extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'procedimientos_proceso_produccion';

    protected $fillable = [
        'procedimiento_id',
        'proceso_id',
    ];

    public function procedimiento()
    {
        return $this->belongsTo(Procedimiento::class);
    }

    public function proceso()
    {
        return $this->belongsTo(Proceso::class);
    }

    public function defectos()
    {
        return $this->belongsToMany(Defecto::class, 'defectos_procedimiento_produccion', 'procedimiento_proceso_id', 'defecto_id');
    }
}
