<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Linea extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'lineas_produccion';

    protected $fillable = [
        'nombre',
        'descripcion',
        'encargado_id',
    ];

    public function encargado()
    {
        return $this->belongsTo(User::class, 'encargado_id');
    }
}
