<?php

namespace App\Filament\Resources\ProcesoResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ProcedimientosProcesoRelationManager extends RelationManager
{
    protected static string $relationship = 'procedimientosProceso';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('procedimiento_id')
                    ->label('Procedimiento')
                    ->options(
                        \App\Models\Procedimiento::pluck('descripcion', 'id')->toArray()
                    )
                    ->native(false)
                    ->required(),
                Forms\Components\Select::make('defectos')
                    ->label('Defectos')
                    ->multiple()
                    ->relationship(name: 'defectos', titleAttribute: 'descripcion')
                    ->options(
                        \App\Models\Defecto::pluck('descripcion', 'id')->toArray()
                    )
                    ->native(false)
                    ->required(),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('id')
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label('ID Procedimiento')
                    ->sortable(),
                Tables\Columns\TextColumn::make('procedimiento.descripcion')
                    ->label('NOMBRE PROCEDIMIENTO'),
                Tables\Columns\TextColumn::make('defectos.descripcion')
                    ->label('DEFECTOS')
                    ->badge()
                    ->color('primary'),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getTitle(Model $ownerRecord, string $pageClass): string
    {
        return 'Procedimientos y Defectos';
    }
}
