<?php $__env->startSection('content'); ?>
    
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Control de Corte</h2>
                <form action="<?php echo e(route('fabricacion.nuevo_corte')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-primary">Registrar Nuevo Corte</button>
                </form>
            </div>
        </div>
        <div class="col-md-12">
            <br>
            <table id="example" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>Correlativo</td>
                        <td>Fecha</td>
                        <td>Cortador</td>
                        <td>Tendedor</td>
                        <td>Cliente</td>
                        <td>Estilo</td>
                        <td>Lienzos</td>
                        <td>Color</td>
                        <td>Linea de negocio</td>
                        <td>Ancho</td>
                        <td>Largo de trazo</td>
                        <td>Inicio de tendido</td>
                        <td>Fin de tendido</td>
                        <td>Inicio de corte</td>
                        <td>Fin de corte</td>
                        <td>Acciones</td>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $ordenes_corte; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orden_corte): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $estado = match ($orden_corte->estado) {
                                1 => 'Pendiente',
                                2 => 'En proceso',
                                3 => 'Finalizado',
                                default => 'Desconocido',
                            };
                            $estado_color = match ($orden_corte->estado) {
                                1 => 'warning',
                                2 => 'primary',
                                3 => 'success',
                                default => 'dark',
                            };
                            $linea_negocio = match ($orden_corte->linea_negocio_id) {
                                1 => 'Maquila',
                                2 => 'KOTON TEXILS',
                                3 => 'SHARKAR',
                                default => 'Desconocido',
                            };
                        ?>
                        <tr>
                            <td class="alert alert-<?php echo e($estado_color); ?>">
                                <a href="<?php echo e(route('fabricacion.detalle_corte', $orden_corte->id)); ?>"
                                    class="d-flex justify-content-center align-items-center">CRT-<?php echo e($orden_corte->id); ?> -
                                    <?php echo e($estado); ?>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                        stroke-linecap="round" stroke-linejoin="round"
                                        class="icon icon-tabler icons-tabler-outline icon-tabler-eye ml-2">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                                        <path
                                            d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" />
                                    </svg>
                                </a>
                            </td>
                            <td><?php echo e($orden_corte->created_at->format('d/m/Y')); ?></td>
                            <td><?php echo e($orden_corte->cortador); ?></td>
                            <td><?php echo e($orden_corte->tendedor); ?></td>
                            <td><?php echo e($orden_corte->cliente->nombre); ?></td>
                            <td><?php echo e($orden_corte->estilo?->nombre); ?></td>
                            <td><?php echo e($orden_corte->lienzos); ?></td>
                            <td><?php echo e($orden_corte->color?->nombre); ?></td>
                            <td><?php echo e($linea_negocio); ?></td>
                            <td><?php echo e($orden_corte->ancho); ?></td>
                            <td><?php echo e($orden_corte->largo_trazo); ?></td>
                            <td><?php echo e($orden_corte->inicio_tendido); ?></td>
                            <td><?php echo e($orden_corte->fin_tendido); ?></td>
                            <td><?php echo e($orden_corte->inicio_corte); ?></td>
                            <td><?php echo e($orden_corte->fin_corte); ?></td>
                            <td class="d-flex justify-content-center align-items-center">
                                
                                <?php if($orden_corte->detalle->count() > 0): ?>
                                    
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal CARGAR IMAGEN-->
    <div class="modal fade" id="modalCargarImagen" tabindex="-1" role="dialog" aria-labelledby="modalCargarImagenLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalCargarImagenLabel">Cargar Imagen</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="file" id="inputImagen" accept="image/*" onchange="previsualizarImagen()">
                    <div id="previewContainer" style="margin-top: 20px; display: none;">
                        <img id="previewImagen" src="" alt="Vista previa de la imagen" style="max-width: 100%;">
                        <br>
                        <button type="button" class="btn btn-secondary" onclick="limpiarInput()">Limpiar</button>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                    <button type="button" class="btn btn-primary" onclick="mostrarSuccess('¡Imagen cargada!');">Guardar
                        Imagen</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal PROCESAR SALIDA-->
    <div class="modal fade" id="procesarSalidaModal" tabindex="-1" aria-labelledby="procesarSalidaModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" style="max-width:1200px !important;">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="procesarSalidaModalLabel">Procesar Salida</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- Paso 1: Selección -->
                    <div id="step1">
                        <label for="selectSalida">Seleccione tipo de salida:</label>
                        <select class="form-control" id="selectSalida">
                            <option value="parcial">Entrega Parcial</option>
                            <option value="completa">Entrega Completa</option>
                        </select>
                        <button class="btn btn-primary mt-3" id="nextButton">Siguiente</button>
                    </div>
                    <!-- Paso 2: Formulario Salida Parcial -->
                    <div id="step2" style="display: none;">
                        <h5>Datos de Ingreso</h5>
                        <table class="table">
                            <thead>
                                <tr>
                                    <td>Correlativo</td>
                                    <td>Descripcion</td>
                                    <td>Cliente</td>
                                    <td>PO</td>
                                    <td>Fecha</td>
                                    <td>Linea de negocio</td>
                                    <td>Estado</td>
                                    <td>Observaciones</td>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>INV-1</td>
                                    <td>Giovani Linea 2</td>
                                    <td>Grupo Onyx</td>
                                    <td>PO 179637</td>
                                    <td>02/07/2024</td>
                                    <td>Maquila</td>
                                    <td>Ingreso Completo</td>
                                    <td>Se recibió el material en buen estado</td>
                                </tr>
                            </tbody>
                        </table>
                        <h5>Detalle de Ingreso</h5>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Cantidad a Entregar</th>
                                    <th scope="col" style='min-width: 300px;'>Descripción</th>
                                    <th scope="col">Unidad de medida</th>
                                    <th scope="col">Cantidad Disponible</th>
                                    <th scope="col">Cantidad Entregada</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <input type="number" class="form-control" value="10">
                                    </td>
                                    <td>Tela algodon para camisas</td>
                                    <td>Rollo</td>
                                    <td>10</td>
                                    <td>0</td>
                                </tr>
                                <tr>
                                    <td>
                                        <input type="number" class="form-control" value="4">
                                    </td>
                                    <td>Zipper para pantalon</td>
                                    <td>Ciento</td>
                                    <td>4</td>
                                    <td>0</td>
                                </tr>
                            </tbody>
                        </table>
                        <button class="btn btn-success" id="processButton">Procesar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="consolidadoModal" tabindex="-1" aria-labelledby="consolidadoModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="consolidadoModalLabel">Consolidado de Orden de Corte</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">Talla</th>
                                <th scope="col">Escala</th>
                                <th scope="col">Cantidad</th>
                                <th scope="col">Total</th>
                            </tr>
                        </thead>
                        <tbody id="consolidadoTableBody">
                            <!-- Filas de la tabla se llenarán dinámicamente -->
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>


    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        function upploadDocument() {
            $('#modalCargarImagen').modal('show');
        }

        function previsualizarImagen() {
            var file = document.getElementById('inputImagen').files[0];
            var reader = new FileReader();

            reader.onloadend = function() {
                document.getElementById('previewImagen').src = reader.result;
                document.getElementById('previewContainer').style.display = 'block';
            }

            if (file) {
                reader.readAsDataURL(file);
            } else {
                document.getElementById('previewImagen').src = "";
                document.getElementById('previewContainer').style.display = 'none';
            }
        }

        function limpiarInput() {
            document.getElementById('inputImagen').value = "";
            document.getElementById('previewImagen').src = "";
            document.getElementById('previewContainer').style.display = 'none';
        }

        function mostrarSuccess(mensaje) {
            Swal.fire({
                icon: 'success',
                title: mensaje,
                showConfirmButton: false,
                timer: 1500
            });
        }

        function solicitudAnulacion() {
            Swal.fire({
                title: 'Anular Corte',
                text: '¿Desea solicitar la autorización para anular esta orden de corte?',
                icon: 'danger',
                showCancelButton: true,
                confirmButtonText: 'Sí, solicitar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire(
                        'Solicitud enviada',
                        'La solicitud para anular el registro ha sido enviada.',
                        'success'
                    );
                }
            });
        }

        function procesarSalida() {
            // Mostrar el modal inicial
            $('#procesarSalidaModal').modal('show');

            // Manejo del botón Siguiente
            document.getElementById('nextButton').onclick = function() {
                const tipoSalida = document.getElementById('selectSalida').value;
                if (tipoSalida === 'completa') {
                    // Mostrar alerta de SweetAlert2 para Salida Completa
                    Swal.fire({
                        icon: 'success',
                        title: 'Se proceso la salida',
                        showConfirmButton: false,
                        timer: 1500
                    });
                    $('#procesarSalidaModal').modal('hide');
                } else if (tipoSalida === 'parcial') {
                    // Mostrar el paso 2 para Salida Parcial
                    document.getElementById('step1').style.display = 'none';
                    document.getElementById('step2').style.display = 'block';
                }
            };

            // Manejo del botón Procesar en Salida Parcial
            document.getElementById('processButton').onclick = function() {
                // Aquí puedes agregar el código para procesar la salida parcial
                Swal.fire({
                    icon: 'success',
                    title: 'Salida Parcial Procesada',
                    showConfirmButton: false,
                    timer: 1500
                });
                $('#procesarSalidaModal').modal('hide');
            };

            function mostrarConsolidado() {
                const consolidadoData = [{
                        talla: 'S',
                        escala: '1',
                        cantidad: '100',
                        total: '100'
                    },
                    {
                        talla: 'M',
                        escala: '2',
                        cantidad: '200',
                        total: '400'
                    },
                    {
                        talla: 'L',
                        escala: '3',
                        cantidad: '300',
                        total: '900'
                    }
                ];

                // Obtener el cuerpo de la tabla
                const tbody = document.getElementById('consolidadoTableBody');

                // Limpiar el contenido previo de la tabla
                tbody.innerHTML = '';

                // Rellenar la tabla con los datos
                consolidadoData.forEach(item => {
                    const tr = document.createElement('tr');
                    tr.innerHTML =
                        `<td>${item.talla}</td>
                    <td>${item.escala}</td>
                    <td>${item.cantidad}</td>
                    <td>${item.total}</td>`;
                    tbody.appendChild(tr);
                });

                // Mostrar el modal
                const consolidadoModal = new bootstrap.Modal(document.getElementById('consolidadoModal'));
                consolidadoModal.show();
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('fabricacion.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/n344795/koton.webdevgt.com/resources/views/fabricacion/dashboard_corte.blade.php ENDPATH**/ ?>