<?php

use Illuminate\Support\Carbon;
use App\Maquinas;


function formatearDosCifras($numero) {
    // Convertir el número a una cadena y agregar un cero adelante si solo tiene una cifra
    return str_pad($numero, 2, '0', STR_PAD_LEFT);
}


function formatearTiempo($numero) {
    // Inicializar el arreglo de resultado
    $arreglo = array(
        'horas' => 0,
        'minutos' => $numero
    );

    // Verificar si el número es mayor o igual a 60
    if ($numero >= 60) {
        // Calcular las horas y minutos
        $arreglo['horas'] = floor($numero / 60);
        $arreglo['minutos'] = $numero % 60;
    }

    $arreglo['horas'] = intval($arreglo['horas']);
    $arreglo['minutos'] = intval($arreglo['minutos']);

    return $arreglo;
}




?>


<?php $__env->startSection('content'); ?>
    


    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Reporte Mensual de Producción</h2>
            </div>
        </div>
    </div>
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
        </div>
        <div class="col">
            <h5>Reporte del:<b> <?php echo e($fechaInicio->format('d-m-Y') . " al " . $fechaFin->format('d-m-Y')); ?> </b></h5>
        </div>
    </div>
    </div>
    <div class="container-fluid">

        <table class="table table-bordered">
            <thead class="thead-light">
                <tr>
                    <th>Maquina</th>
                    <th>Horas trabajadas</th>
                    <th>Cantidad producida</th>
                    <th>Rendimiento por hora</th>
                </tr>
            </thead>
            <tbody>

                <?php $__currentLoopData = $reportes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reporte): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <?php
                            $maquina = Maquinas::find($reporte->id_maquina);
                            echo $maquina->maquina;
                            ?>
                        </td>
                        <td><?php
                            $resultado = formatearTiempo($reporte->total_minutos);
                            if ($resultado['horas'] >= 1) {
                                echo formatearDosCifras($reporte->total_horas+$resultado['horas']);
                                echo ":";
                                echo formatearDosCifras($resultado['minutos']);
                            }else{
                                echo formatearDosCifras($reporte->total_horas);
                                echo ":";
                                echo formatearDosCifras($resultado['minutos']);
                            }

                        ?></td>
                        <td><?php echo e(number_format($reporte->total_cantidad, 2, '.', ',')); ?></td>
                        <td>
                            <?php
                            if ($reporte->total_cantidad) {
                                $promedio = $reporte->total_cantidad / abs($reporte->total_horas);
                                echo number_format($promedio, 2, '.', ',');
                            }
                            
                            ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('fabricacion.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/fabricacion/historico_maquinaria_mes.blade.php ENDPATH**/ ?>