<?php $__env->startSection('content'); ?>


<div id="contenedor_interno" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="<?php echo e(route('ventas.dashboard')); ?>">Orden de Produción</a></li>
          <li class="breadcrumb-item active" aria-current="page">Actualizar</li>
        </ol>
      </nav>
      <form action="<?php echo e(route('fabricacion.op_actualizar',$op->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <input type="submit" class="botonColor" value="Actualizar" />
        <a data-toggle="modal" data-target="#exampleModal" class="btn btn-success">Entrega parcial</a>
        <a data-toggle="modal" data-target="#exampleModal" class="btn btn-danger">Terminar OP</a>
    </div>
    <hr>
  </div>
</div>

<div id="contenedor_contenido" class="container-fluid px-lg-5">
<div class="row">
  <div class="col-md-12">
    <h2>Orden de Produción: OP/<?php echo e($op->id); ?></h2>
  </div>
  <div class="col-md-12">
   
      <div class="row">
        <div class="col-md-6">
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Es para inventario</label>
            <div class="col-sm-8">
              <input class="form-check-input" <?php echo e($op->inventario==1 ? "checked" : ""); ?> type="checkbox" id="gridCheck" name="inventario" value="1">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Cliente</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext" value="<?php echo e($op->cliente->nombre); ?>" placeholder="">
              <input type="hidden" class="form-control-plaintext" name="id_cliente" value="<?php echo e($op->id_cliente); ?>">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Producto</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext" value="<?php echo e($op->producto->nombre); ?>" placeholder="">
              <input type="hidden" id="id_producto" class="form-control-plaintext" name="id_producto" value="<?php echo e($op->id_producto); ?>">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Cantidades para producir</label>
            <div class="col-sm-8">
              <input type="text" id="cantidad" readonly class="form-control-plaintext" name="cantidad" value="<?php echo e($op->cantidad); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Fecha Prevista:</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext daterange-single" name="fecha_prevista" value="<?php echo e(date("d-m-Y", strtotime($op->fecha_prevista))); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row bg-primary">
            <label for="" class="col-sm-4 col-form-label">Fecha Entrega:</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext daterange-single" name="fecha_entrega" value="<?php echo e($op->fecha_entrega ? date("d-m-Y", strtotime($op->fecha_entrega)):''); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Lista de materiales</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext" name="lista_materiales" value="<?php echo e($op->lista_materiales); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Condiciones de entrega</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext" name="condiciones_entrega" value="<?php echo e($op->condiciones_entrega); ?>" placeholder="">
            </div>
          </div>
        </div>


        <div class="col-md-6">

          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Vendedor</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext" value="Admin" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Número de cotización</label>
            <div class="col-sm-8">
              <input type="text" class="form-control-plaintext" value="CO/<?php echo e($op->id_cotizacion); ?>" placeholder="">
              <input type="hidden" name="id_cotizacion" value="<?php echo e($op->id_cotizacion); ?>">
              <input type="hidden" name="id_cotizacion_producto" value="<?php echo e($op->id_cotizacion_producto); ?>">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Número de orden compra</label>
            <div class="col-sm-8">
              <input type="text" class="form-control-plaintext" name="numero_oc" value="<?php echo e($op->numero_oc); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">kgs por Millar</label>
            <div class="col-sm-8">
              <input id="kgs_millar" name="kgs_millar" type="text" onchange="materialProcesar(this)" class="form-control-plaintext" value="<?php echo e($op->kgs_millar); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Kgs a Procesar</label>
            <div class="col-sm-8">
              <input type="text" id="kgProcesar" name="kgs_procesar" readonly class="form-control-plaintext" value="<?php echo e($op->kgs_procesar); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Micras</label>
            <div class="col-sm-8">
              <input type="text"  class="form-control-plaintext" name="micras" value="<?php echo e($op->micras); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Caracteristicas</label>
            <div class="col-sm-8">
              <input type="text"  class="form-control-plaintext" name="caracteristicas" value="<?php echo e($op->caracteristicas); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Observaciones</label>
            <div class="col-sm-8">
              <input type="text"  class="form-control-plaintext" name="observaciones" value="<?php echo e($op->observaciones); ?>" placeholder="">
            </div>
          </div>
        </div>
      </div>
    </form>

  </div>
  <br>
  <br><br>
  <br>
  <div class="col-md-12">
    <h3 style="text-align: center">ENTREGAS PARCIALES</h3>
  </div>
  <div class="col-md-12">
    <table class="table">
      <thead>
        <tr>
          <th scope="col">Producto</th>
          <th scope="col">Cantidad</th>
          <th scope="col">Unidad de medida</th>
          <th scope="col">Fecha</th>
          <th scope="col">Observación</th>
        </tr>
      </thead>
      <tbody id="contenedorProductos">
        
        <?php $__currentLoopData = $opParciales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opParcial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
          
          <td><?php echo e($opParcial->op->producto->nombre); ?></td>
          <td><?php echo e($opParcial->cantidad); ?></td>
          <td><?php echo e($opParcial->op->producto->medida->nombre); ?></td>
          <td><?php echo e(date("d/m/Y", strtotime($opParcial->created_at))); ?></td>
          <td><?php echo e($opParcial->observaciones); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
      </tbody>
    </table>     
    </div>
  

</div>
</div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">ENTREGAS PARCIALES</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Cantidad:</label>
            <input type="text" class="form-control" id="cantidad_parcial">
          </div>
          <div class="form-group">
            <label for="message-text" class="col-form-label">Observación:</label>
            <textarea class="form-control" id="observacion_parcial"></textarea>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
        <button id="entregaParcial" type="button" class="btn btn-primary">Entregar</button>
      </div>
    </div>
  </div>
</div>
<script>
  var kgs_millar=document.getElementById('kgs_millar');
  materialProcesar(kgs_millar)

  function nuevaFila(){
    var row = document.getElementsByClassName("producto"); // find row to copy
    console.log(row);
    var table = document.getElementById("contenedorProductos"); // find table to append to
    var clone = row[0].cloneNode(true); // copy children too
    table.appendChild(clone); // add new row to end of table
  }
  function materialProcesar(element){
    
    var cantidad=document.getElementById('cantidad').value;
    var kgMillar=element.value;
    var total=parseFloat(kgMillar)*parseFloat(cantidad);
    document.getElementById('kgProcesar').value=total;
    console.log(total);
    
  }
  $('#entregaParcial').click(function(){
    var token = '<?php echo e(csrf_token()); ?>';
    var cantidad=$('#cantidad_parcial').val();
    var id_producto=$('#id_producto').val();
    var idOP='<?php echo e($op->id); ?>';
    var descripcion=$('#observacion_parcial').val();
      $.ajax({
        type:'POST',
        url:'<?php echo e(route('fabricacion.op_parcial')); ?>',
        headers: {'X-CSRF-TOKEN': token},
        data:{
          cantidad:cantidad,
          descripcion:descripcion,
          id_producto:id_producto,
          idOP:idOP
        },
        success:function(data){
          location.reload();
        }
      });
  });
  
 
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('fabricacion.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\erp\resources\views/fabricacion/orden_produccion.blade.php ENDPATH**/ ?>