<?php $__env->startSection('content'); ?>


<script>
  $(document).ready(function() {
      $("#botonEnviar").on("click", function() {
          var boton = $(this);
          boton.hide();
  
          // Después de 3 segundos, mostrar el botón nuevamente
          setTimeout(function() {
              boton.show();
          }, 2000);
      });
  });
  </script>
<form action="<?php echo e(route('contabilidad.guardar_facturas')); ?>" method="POST" onkeydown="return event.key != 'Enter';" enctype="multipart/form-data" id="formEnviar">
  <?php echo csrf_field(); ?>
<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('contabilidad.dashboard')); ?>">Factura</a></li>
            <li class="breadcrumb-item active" aria-current="page">Nueva</li>
          </ol>
        </nav>
        
          <input id="botonEnviar" type="submit"  class="botonColor" value="Guardar Factura" />
      </div>
      <hr>
    </div>
</div>

<div id="contenedor_contenido" class="container-fluid px-lg-5">
  <div class="row">
    <div class="col-md-12 d-flex align-items-center">
                    <h2>Factura</h2>
                    <div class="mt-4 d-flex align-items-center">
                        <h4 class="ml-4"> - Referencia Pedido: </h4>
                        <?php $__currentLoopData = $facturas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cotizacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <h4 class="ml-2"><?php echo e($cotizacion['no_cotizacion']); ?>/ </h4>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
    <div class="col-md-12">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cliente</label>
              <div class="col-sm-8">
                  <p><?php echo e($cliente->nombre); ?></p>
                  <input type="hidden" name="id_cliente" value="<?php echo e($cliente->id); ?>">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Nit</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" id="nit" value="<?php echo e($cliente->nit); ?>" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Dirección</label>
              <div class="col-sm-8">
                <p><?php echo e($cliente->direccion); ?></p>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Observaciones Cotización</label>
              <div class="col-sm-8">
                <p>
                
                  <?php $__currentLoopData = $facturas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cotiza): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($cotiza['comentario_coti']); ?>

                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </p>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Moneda</label>
              <div class="col-sm-8">
                <select class="form-control" name="id_moneda" id="exampleFormControlSelect1">
                  <option <?php echo e($cliente->id_moneda == 1 ? "selected" : ""); ?> value="1">Q</option>
                  <option <?php echo e($cliente->id_moneda == 2 ? "selected" : ""); ?> value="2">$</option>
                </select>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Condiciones de pago</label>
              <div class="col-sm-8">
                <?php if($cliente->condiciones_pago == 1): ?>
                  <p>Contado</p>
                <?php endif; ?>
                <?php if($cliente->condiciones_pago == 6): ?>
                  <p>8 días</p>
                <?php endif; ?>
                <?php if($cliente->condiciones_pago == 2): ?>
                  <p>15 días</p>
                <?php endif; ?>
                <?php if($cliente->condiciones_pago == 3): ?>
                  <p>30 días</p>
                <?php endif; ?>
                <?php if($cliente->condiciones_pago == 4): ?>
                  <p>45 días</p>
                <?php endif; ?>
                <?php if($cliente->condiciones_pago == 5): ?>
                  <p>60 días</p>
                <?php endif; ?>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Régimen fiscal
              </label>
              <div class="col-sm-8">
                <?php if($cliente->tipo_regimen == 1): ?>
                <p>Régimen Normal</p>
                <?php endif; ?>
                <?php if($cliente->tipo_regimen == 2): ?>
                  <p>Decreto régimen 2989</p>
                <?php endif; ?>
              </div>
            </div>
          </div>


          <div class="col-md-6">
            
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Número Facturar SAT</label>
              <div class="col-sm-8">
                <input type="text" name="numero_factura" class="form-control-plaintext" value="" placeholder="" required>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">PDF Factura 1</label>
              <div class="col-sm-8">
                <input type="file" name="pdf_factura" class="form-control-plaintext" accept="application/pdf,image/*,.xls,.xlsx" required>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">PDF Factura 2</label>
              <div class="col-sm-8">
                <input type="file" name="pdf_factura2" class="form-control-plaintext" accept="application/pdf,image/*,.xls,.xlsx" >
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">PDF Factura 3</label>
              <div class="col-sm-8">
                <input type="file" name="pdf_factura3" class="form-control-plaintext" accept="application/pdf,image/*,.xls,.xlsx" >
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">PDF Factura 4</label>
              <div class="col-sm-8">
                <input type="file" name="pdf_factura4" class="form-control-plaintext" accept="application/pdf,image/*,.xls,.xlsx" >
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">PDF Factura 5</label>
              <div class="col-sm-8">
                <input type="file" name="pdf_factura5" class="form-control-plaintext" accept="application/pdf,image/*,.xls,.xlsx" >
              </div>
            </div>
          </div>
        </div>
        <!-- Productos -->
        <div class="row">
          <div class="col-md-12">
            <ul class="nav nav-tabs" id="myTab">
              <li class="nav-item">
                  <a href="#home" class="nav-link" data-toggle="tab">Lista del pedido</a>
              </li>
            </ul>
            <div class="tab-content">
              <div class="tab-pane fade" id="home">
                <table class="table">
                  <thead>
                    <tr>
                      <th scope="col">Descripción de Producto</th>
                      <th scope="col">Cantidad</th>
                      <th scope="col">Unidad de medida</th>
                      <th scope="col">Precio unitario</th>
                      <th scope="col">Impuestos</th>
                      <th scope="col">Cotización</th>
                      <th scope="col">Total</th>
                    </tr>
                  </thead>
                  <tbody id="contenedorProductos">
                    <?php $__currentLoopData = $facturas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factura): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr class="producto"> 
                        <td><p><?php echo e($factura['nombre']); ?></p></td>
                        <td><p><?php echo e($factura['cantidad']); ?></p></td>
                        <td><p><?php echo e($factura['medida']); ?></p></td>
                        <td><p><?php echo e(number_format($factura['precio'],4,'.',',')); ?></p></td>
                        <td><p><?php echo e(number_format($factura['iva'],2,'.',',')); ?></p></td>
                        <td><a  href="<?php echo e(asset($factura['url'])); ?>" target='_blank' download>CO_<?php echo e($factura['id_co']); ?> <i class="far fa-file-pdf"></i></a></td>
                        <td><p><?php echo e(number_format($factura['total'],2,'.',',')); ?></p></td>
                        <input type="hidden" name="id_producto[]" value="<?php echo e($factura['id_producto']); ?>">
                        <input type="hidden" name="nombre_producto[]" value="<?php echo e($factura['nombre']); ?>">
                        <input type="hidden" name="cantidad[]" value="<?php echo e($factura['cantidad']); ?>">
                        <input type="hidden" name="precio[]" value="<?php echo e($factura['precio']); ?>">
                        <input type="hidden" name="id_salida[]" value="<?php echo e($factura['id_salida']); ?>">
                        <input type="hidden" name="total[]" value="<?php echo e($factura['total']); ?>">
                        
                      </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                  </tbody>
                </table>
                <hr>
                <div class="total">
                  <input type="hidden" name="total_t" value="<?php echo e($total_t); ?>">
                  <p>Impuestos: Q <span id="impuestos"><?php echo e(number_format($iva_t,2,'.',',')); ?></span></p>
                  <p class="mostrarTotal">Total: Q <?php echo e(number_format($total_t,2,'.',',')); ?><span id="totalTotal"></span></p>
                </div>
              </div>
             

            </div>
        </div>
      

    </div>
  </div>
</div>
</form>
<script>
  function nuevaFila(){
    var row = document.getElementsByClassName("producto"); // find row to copy
    var table = document.getElementById("contenedorProductos"); // find table to append to
    var clone = row[0].cloneNode(true); // copy children too
    table.appendChild(clone); // add new row to end of table
    clone.getElementsByClassName('precio_sugerido')[0].value='';
    clone.getElementsByClassName('cantidad')[0].value='';
    clone.getElementsByClassName('unidad_medida')[0].value='';
    clone.getElementsByClassName('idMedida')[0].value=0;
    clone.getElementsByClassName('impuestos')[0].value='';
    clone.getElementsByClassName('subTotal')[0].value='';
  }
  function infoCliente(elemento){
    jQuery( document ).ready(function() {
      var token = '<?php echo e(csrf_token()); ?>';
      $.ajax({
        type:'POST',
        url:'<?php echo e(route('ventas.buscar_cliente')); ?>',
        headers: {'X-CSRF-TOKEN': token},
        data:{
          id_cliente:elemento.value,
        },
        success:function(data){
          $('#nit').val(data.nit);
          $('#direccion').val(data.direccion);
          $('#direccion').val(data.direccion);
          console.log('hola',data.condiciones_pago);
          $("#condiciones_pago").val(data.condiciones_pago).change();
        }
      });
    });
  }
  function calcularSubTotal(elemento){
    var padre=elemento.parentElement.parentElement;
    var precio=padre.getElementsByClassName('precio_sugerido')[0].value;
    var cantidad=padre.getElementsByClassName('cantidad')[0].value;
    var subTotal=precio*cantidad;
    var impuestos=subTotal*0.12;
    var totalImpuesto=0;
    var totalTotal=0;
    padre.getElementsByClassName('impuestos')[0].value='Q '+impuestos.toFixed( 2 ).replace(/\d(?=(\d{3})+\.)/g, '$&,');
    var subTotal=impuestos+subTotal;
    padre.getElementsByClassName('subTotal')[0].value='Q '+subTotal.toFixed( 2 ).replace(/\d(?=(\d{3})+\.)/g, '$&,');
    //Sumar impuestos
    console.log(document.querySelectorAll('impuestos'));
    document.querySelectorAll('.impuestos').forEach(element => {
      var purgar_impuesto=element.value.replace(',', '').replace('Q', '');
      totalImpuesto=parseFloat(totalImpuesto)+parseFloat(purgar_impuesto);
    });
    document.getElementById('impuestos').innerHTML=totalImpuesto.toFixed( 2 ).replace(/\d(?=(\d{3})+\.)/g, '$&,');

    document.querySelectorAll('.subTotal').forEach(element => {
      
      var purgar_total=element.value.replace(',', '').replace('Q', '');
      console.log(purgar_total);
      totalTotal=parseFloat(totalTotal)+parseFloat(purgar_total);
    });
    document.getElementById('totalTotal').innerHTML=totalTotal.toFixed( 2 ).replace(/\d(?=(\d{3})+\.)/g, '$&,');
  }
  function infoProducto(elemento){
    jQuery( document ).ready(function() {
      var token = '<?php echo e(csrf_token()); ?>';
      $.ajax({
        type:'POST',
        url:'<?php echo e(route('ventas.buscar_producto')); ?>',
        headers: {'X-CSRF-TOKEN': token},
        data:{
          id_producto:elemento.value,
        },
        success:function(data){
          var padre=elemento.parentElement.parentElement;
          padre.getElementsByClassName('precio_sugerido')[0].value='';
          padre.getElementsByClassName('cantidad')[0].value='';
          padre.getElementsByClassName('unidad_medida')[0].value='';
          padre.getElementsByClassName('idMedida')[0].value=0;
          padre.getElementsByClassName('impuestos')[0].value='';
          padre.getElementsByClassName('subTotal')[0].value='';
          $(padre).find('.unidad_medida').val(data.medida.nombre);
          $(padre).find('.idMedida').val(data.medida.id);
          $(padre).find('.precio_sugerido').val(data.precio_venta);
        }
      });
    });
  }
  $( "#formEnviar" ).submit(function( event ) {
    document.getElementById('botonEnviar').disabled = true;
  });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('contabilidad.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/contabilidad/crear_facturas.blade.php ENDPATH**/ ?>