<?php $__env->startSection('content'); ?>


<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            
            <?php if(auth()->user()->id ==7 || Auth::user()->id==12): ?>         
              <li class="breadcrumb-item"><a href="<?php echo e(route('ventas.dashboard_produccion_gerencia')); ?>">Ordenes de Producción</a></li>
            <?php else: ?>
              <li class="breadcrumb-item"><a href="<?php echo e(route('ventas.dashboard_produccion')); ?>">Ordenes de Producción</a></li>      
            <?php endif; ?>
            
            <li class="breadcrumb-item active" aria-current="page">Ver</li>
          </ol>
        </nav>
      </div>
      <hr>
    </div>
</div>
<form action="<?php echo e(route('ventas.orden_produccion_ok2',$op->id)); ?>" method="POST">
<div id="contenedor_contenido" class="container-fluid px-lg-5">
  <div class="row">
    <div class="col-md-12">
      <h2> Orden de Producción: OP<?php echo e($op->id); ?> <a href="<?php echo e(route('contabilidad.ver_cuenta_corriente_info',$op->cliente->id)); ?>" target="_blank"><i class="fas fa-search-dollar"  style="font-size: 26px;"></i></a></h2>
      
          <?php echo csrf_field(); ?>
          <div class="form-group">
          <label for="exampleFormControlTextarea1">Observaciones</label>
          <textarea class="form-control" id="exampleFormControlTextarea1" name='comentario_ing' rows="3"></textarea>
          <input type="submit" class="botonColor2" value="ACTUALIZAR" /> 
        </div>
        
    </div>
   
    <div class="col-md-12">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Es para inventario</label>
              <div class="col-sm-8">
                <input class="form-check-input" <?php echo e($op->inventario==1 ? "checked" : ""); ?> type="checkbox" id="gridCheck" name="inventario" value="1">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cliente</label>
              <div class="col-sm-8">
                <p class="inputText"><?php echo e($op->cliente->nombre??'Inventario'); ?></p>
                <input type="hidden" class="form-control-plaintext" name="id_cliente" value="<?php echo e($op->id_cliente); ?>">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Producto</label>
              <div class="col-sm-8">
                <p class="inputText"><?php echo e($op->producto->nombre); ?></p>
                <input type="hidden" class="form-control-plaintext" name="id_producto" value="<?php echo e($op->id_producto); ?>">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cantidades para producir</label>
              <div class="col-sm-8">
                <input type="text" id="cantidad" class="form-control-plaintext" name="cantidad" value="<?php echo e($op->cantidad); ?>" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Unidad de medida</label>
              <div class="col-sm-8">
                <input type="text" id="cantidad" readonly class="form-control-plaintext" name="unidad_medida" value="<?php echo e($op->producto->medida->nombre); ?>" placeholder="">
              </div>
            </div>
            <?php if($op->fecha_entrega): ?>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Fecha Planificada Producción:</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext daterange-single" name="fecha_entrega" value="<?php echo e(date("d-m-Y", strtotime($op->fecha_entrega))); ?>" placeholder="">
              </div>
            </div>
            <?php endif; ?>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Lista de materiales</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" name="lista_materiales" value="<?php echo e($op->lista_materiales); ?>" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Condiciones de entrega</label>
              <div class="col-sm-8">
                <textarea class="form-control" name="condiciones_entrega" id="" cols="30" rows="4" required readonly><?php echo e($op->condiciones_entrega); ?></textarea>
              </div>
            </div>
          </div>


          <div class="col-md-6">

            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Vendedor</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" value="<?php echo e($op->cliente->info_ejecutivo->name??'Inventario'); ?>" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Número de cotización</label>
              <div class="col-sm-8">
                <a href="<?php echo e(asset("/cotizaciones/CO_".$op->id_cotizacion_producto)); ?>.pdf" target='_blank'><i class="fas fa-camera"></i> <?php echo e($op->id_cotizacion_producto); ?></a>
                <input type="hidden" class="form-control-plaintext" value="CO<?php echo e($op->id_cotizacion_producto); ?>" placeholder="">
                <input type="hidden" name="id_cotizacion" value="<?php echo e($op->id_cotizacion); ?>">
                <input type="hidden" name="id_cotizacion_producto" value="<?php echo e($op->id_cotizacion_producto); ?>">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Número de orden compra</label>
              <div class="col-sm-8">
                <input type="text" class="form-control-plaintext" name="numero_oc" value="<?php echo e($op->numero_oc); ?>" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">kgs por Millar</label>
              <div class="col-sm-8">
                <input id="kgs_millar" name="kgs_millar" type="text" onchange="materialProcesar(this)" class="form-control-plaintext" value="<?php echo e($op->kgs_millar); ?>" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Kgs a Procesar</label>
              <div class="col-sm-8">
                <input type="text" id="kgProcesar" name="kgs_procesar" readonly class="form-control-plaintext" value="<?php echo e($op->kgs_procesar); ?>" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Micras</label>
              <div class="col-sm-8">
                <input type="text"  class="form-control-plaintext" name="micras" value="<?php echo e($op->micras); ?>" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Caracteristicas</label>
              <div class="col-sm-8">
                <input type="text"  class="form-control-plaintext" name="caracteristicas" value="<?php echo e($op->caracteristicas); ?>" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Observaciones</label>
              <div class="col-sm-8">
                <p><?php echo e($op->observaciones); ?></p>
                <input type="hidden"  class="form-control-plaintext" name="observaciones" value="<?php echo e($op->observaciones); ?>" placeholder="">
              </div>
            </div>
          </div>
        </div>
        <br>
        <div class="col-md-12">
          <h3 style="text-align: center">ENTREGAS PARCIALES</h3>
        </div>
        <div class="col-md-12">
          <table class="table">
            <thead>
              <tr>
                <th scope="col">Producto</th>
                <th scope="col">Cantidad</th>
                <th scope="col">Unidad de medida</th>
                <th scope="col">Fecha</th>
                <th scope="col">Observación</th>
              </tr>
            </thead>
            <tbody id="contenedorProductos">
              
              <?php $__currentLoopData = $opParciales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opParcial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                
                <td><?php echo e($opParcial->op->producto->nombre); ?></td>
                <td><?php echo e($opParcial->cantidad); ?></td>
                <td><?php echo e($opParcial->op->producto->medida->nombre??''); ?></td>
                <td><?php echo e(date("d/m/Y", strtotime($opParcial->created_at))); ?></td>
                <td><?php echo e($opParcial->observaciones); ?></td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              
            </tbody>
          </table>     
          </div>

    </div>
  </div>
</div>
</form>
<script>
  var kgs_millar=document.getElementById('kgs_millar');
  materialProcesar(kgs_millar)

  function nuevaFila(){
    var row = document.getElementsByClassName("producto"); // find row to copy
    console.log(row);
    var table = document.getElementById("contenedorProductos"); // find table to append to
    var clone = row[0].cloneNode(true); // copy children too
    table.appendChild(clone); // add new row to end of table
  }
  function materialProcesar(element){
    
    var cantidad=document.getElementById('cantidad').value;
    var kgMillar=element.value;
    var total=parseFloat(kgMillar)*parseFloat(cantidad);
    document.getElementById('kgProcesar').value=total.toFixed(2);
    console.log(total);
    
  }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ventas.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/ventas/orden_produccion_ver.blade.php ENDPATH**/ ?>