<?php $__env->startSection('content'); ?>
    
    <style>
        #logo {
            width: 140px;
        }

        #contenido {
            padding-left: 10px;
            padding-right: 10px;
        }

        #fecha {
            text-align: right;
        }

        .tituloH {
            line-height: 2px;
        }

        table {
            width: 100%;
        }

        #descripcionCotizacion th,
        #descripcionCotizacion td {
            border: 1px solid black;
            text-align: center;
        }

        #descripcionCotizacion {
            margin-top: 25px;
            margin-bottom: 30px;
        }

        .infoPie {
            margin-top: 25px;
            text-align: center;
            margin: 0px;
        }

        .final {
            text-align: center;
            color: #666;
        }

        #firma {
            text-align: center;
        }

        #firma img {
            width: 100px;
        }

        #cotizacion {
            text-align: right;
        }

        #firma2 {
            width: 60px;
        }

        #anulado {
            position: fixed;
            z-index: 1000;
            color: red;
            font-size: 6rem;
            top: 40%;
            font-weight: 700;
            opacity: .5;
            margin-left: 33%;
        }

        .vista_ejecutivo {
            float: right;
            background: #0c9331;
            color: #fff;
            padding: 5px 10px;
            margin-top: -50px;
        }

        #info_cuenta {
            clear: both;
            display: block;
        }
    </style>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
        }

        .flex {
            display: flex;
        }

        .flex-col {
            flex-direction: column;
        }

        .justify-between {
            justify-content: space-between;
        }

        .justify-center {
            justify-content: center;
        }

        .justify-around {
            justify-content: space-around;
        }

        .items-center {
            align-items: center;
        }

        .container {
            width: 800px;
            margin: 0 auto;
            background: #fff;
            padding: 50px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .mr-10 {
            margin-right: 60px;
        }

        .-mt-10 {
            margin-top: -20px;
        }

        .w-50 {
            width: 50%;
        }

        .w-1\/3 {
            width: 33.333333%;
        }

        .px-10 {
            padding-left: 10px;
            padding-right: 10px;
        }

        .text-center {
            text-align: center;
        }

        .bg-blue-300 {
            background-color: #cfe2f3;
        }

        .text-blue-600 {
            color: #2c5282;
        }

        .line-height-4 {
            line-height: .6;
        }

        .text-header {
            line-height: .4;
        }

        .border-b {
            border-bottom: 1px solid #000;
            padding-bottom: 4px;
        }

        .underline {
            text-decoration: underline;
        }

        .font-bold {
            font-weight: bold;
        }

        .w-full {
            width: 100%;
        }

        .header .left {
            width: 100%;
            /* reducir el espaciado vertical del texto */
            line-height: 1;
        }

        .header .logo {
            width: 150px;
            height: 150px;
            margin-right: 10px;
        }

        .header .right {
            width: 100%;
            text-align: right;
        }

        .info p {
            margin: 5px 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table,
        th,
        td {
            border: 1px solid #000;
        }

        th,
        td {
            padding: 8px;
            text-align: left;
        }

        thead {
            background-color: #f0f0f0;
        }

        tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .observaciones {
            font-size: 0.9em;
        }

        .observaciones ul {
            margin: 0;
            padding-left: 20px;
        }

        .observaciones ul li {
            margin-bottom: 5px;
        }
    </style>
    <div id="contenedor_interno" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('ventas.dashboard_gerencia')); ?>">Cotizaciones</a></li>
                        <li class="breadcrumb-item active"><?php echo e($infoCotizacion['id']); ?> - <?php echo e($infoCotizacion['referencia']); ?>

                            <?php echo e($infoCotizacion['stock'] ? ' - INVENTARIO' : ''); ?> <a id="info_cuenta"
                                href="<?php echo e(route('contabilidad.ver_cuenta_corriente_info', $infoCotizacion['id_cliente'])); ?>"
                                target="_blank"><i class="fas fa-search-dollar" style="font-size: 26px;"></i></a></li>
                    </ol>
                    <a class="vista_ejecutivo" href="<?php echo e(route('ventas.dashboard')); ?>" title="Generar Cotización">VISTA
                        EJECUTIVO</a>
                </nav>
                <?php if($infoCotizacion['estatus'] == 1): ?>
                    <h3 class="text-danger" style="display: none;" id="alertaClienteMoroso">Alerta</h3>
                    <div class="row">
                        <div class="col-md-6">
                            <form action="<?php echo e(route('ventas.ok_cotizacion2')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="stock" value="<?php echo e($infoCotizacion['stock']); ?>">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Observaciones: APROBADO</label>
                                    <textarea class="form-control" id="exampleFormControlTextarea1" name='observaciones' rows="3"></textarea>
                                    <input type="hidden" name='idCotizacion' value='<?php echo e($infoCotizacion['id']); ?>'>
                                    <input type="submit" class="botonColor" name="accion" value="aprobado" />
                                    <input type="submit" class="botonColor2" name="accion" value="rechazado" />
                                </div>
                            </form>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <hr>
        </div>
    </div>
    
    <div class="">
        <div class="header">
            <div class="left flex justify-between">
                <img src="<?php echo e(asset('images/logo_concisa.png')); ?>" alt="Logo" class="logo">
                <div>
                    <div class="right">
                        <p>No. C<strong><?php echo e($infoCotizacion['id']); ?> - <?php echo e($infoCotizacion['referencia']); ?></strong></p>
                    </div>
                    <div class="info">
                        <p>KOTON TEXTILS</p>
                        <p>7a. Av. 14-44 zona 9, Edificio La Galería, 3er Nivel, Oficina 302, Guatemala</p>
                        <p>Tel. +502 2493-3351, 3094-6441 info@sharkarstore.com</p>
                        <p>NIT 10965473-0</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="flex w-full">
            <div class="mr-10 font-bold line-height-4">
                <p>EMPRESA:</p>
                <p>DIRECCION:</p>
                <p>FECHA:</p>
                <p>NIT:</p>
            </div>
            <div class="text-header">
                <p class="w-full border-b"><?php echo e($infoCotizacion['nombre_cliente']); ?></p>
                <p class="w-full border-b"><?php echo e($infoCotizacion['direccion_cliente'] ?? 'N/A'); ?></p>
                <p class="w-full border-b"><?php echo e($infoCotizacion['dia']); ?> de <?php echo e($infoCotizacion['mes']); ?> del
                    <?php echo e($infoCotizacion['ano']); ?></p>
                <div class="flex w-full">
                    <p class="w-full border-b mr-10"><?php echo e($infoCotizacion['nit_cliente'] ?? 'N/A'); ?></p>
                    <div class="flex w-50">
                        <p class="font-bold">TEL:</p>
                        <p class="w-full border-b"><?php echo e($infoCotizacion['telefono_cliente'] ?? 'N/A'); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <table>
            <thead>
                <tr class="bg-blue-300">
                    <th>PROD.</th>
                    <th>TALLA</th>
                    <th>DESCRIPCIÓN DEL INSUMO</th>
                    <th>UNI. MEDIDA</th>
                    <th>PRECIO UNIDAD</th>
                    <th>TOTAL Q</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e($infoCotizacion['categoria']); ?></td>
                    <td><?php echo e($infoCotizacion['medida']); ?></td>
                    <td><?php echo e($infoCotizacion['nombre_producto']); ?></td>
                    <td><?php echo e($infoCotizacion['cantidad']); ?></td>
                    <td><?php echo e($infoCotizacion['id_moneda'] ?? 'Q'); ?>

                        <?php echo e(number_format($infoCotizacion['precio'], 2, '.', ',')); ?>

                    </td>
                    <td><?php echo e($infoCotizacion['id_moneda'] ?? 'Q'); ?>

                        <?php echo e(number_format($infoCotizacion['total'], 2, '.', ',')); ?>

                    </td>
                </tr>
                <tr>
                    <td colspan="5" class="bg-blue-300"><strong>TOTAL</strong></td>
                    <td class="bg-blue-300"><strong><?php echo e($infoCotizacion['id_moneda'] ?? 'Q'); ?>

                            <?php echo e(number_format($infoCotizacion['total'], 2, '.', ',')); ?></strong></td>
                </tr>
            </tbody>
        </table>

        <div class="observaciones">
            <p><strong>OBSERVACIONES:</strong></p>
            <ul>
                <li>El tiempo de garantía de la prenda es de 12 meses por daños de confección o descomposición del
                    material.</li>
                <li>El tiempo de entrega de las prendas es en 05 días hábiles desde la confirmación de la orden.</li>
                <li>El tiempo de sostenimiento de oferta es de 45 días</li>
            </ul>
        </div>

        <div class="flex items-center w-full text-center justify-center">
            <div class="px-10 flex flex-col items-center justify-center w-1/3">
                <img src="<?php echo e(asset('images/ana2.png')); ?>" alt="FIRMA1" style="width: 100px;">
                <div class="line-height-4">
                    <p>AUT.REPRESENTANTE LEGAL</p>
                    <p class="text-blue-600">Ana Batz</p>
                </div>
            </div>
            <div class="px-10 flex flex-col items-center justify-center w-1/3">
                <img src="<?php echo e(asset('images/sello2.png')); ?>" alt="SELLO" style="width: 200px;">
            </div>
            <div class="px-10 flex flex-col items-center justify-center w-1/3">
                <img src="<?php echo e($infoCotizacion['firma']); ?>" alt="FIRMA2" style="width: 100px;">
                <div class="line-height-4">
                    <p>ASESOR COMERCIAL</p>
                    <p class="text-blue-600"><?php echo e($infoCotizacion['nombre_ejecutivo']); ?></p>
                </div>
            </div>
        </div>
        <div class="w-full">
            <img src="<?php echo e(asset('images/pie.png')); ?>" alt="FORMA" class="w-full">
        </div>
    </div>
    <script>
        var cliente = <?php echo e($infoCotizacion['id_cliente']); ?>;

        function infoCliente(elemento) {
            jQuery(document).ready(function() {
                var token = '<?php echo e(csrf_token()); ?>';
                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(route('ventas.buscar_cliente')); ?>',
                    headers: {
                        'X-CSRF-TOKEN': token
                    },
                    data: {
                        id_cliente: elemento,
                    },
                    success: function(data) {
                        if (parseInt(data.mora) > 0) {
                            $('#alertaClienteMoroso').css('display', 'block');
                            document.getElementById('alertaClienteMoroso').textContent =
                                'Cliente con mora de ' + data.mora + ' días';
                        }
                    }
                });
            });
        }

        document.addEventListener("DOMContentLoaded", function(event) {
            infoCliente(cliente);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ventas.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/n344795/koton.webdevgt.com/resources/views/ventas/cotizacion_ok.blade.php ENDPATH**/ ?>