<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Prueba PDF</title>
</head>
<style>
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 20px;
        background-color: #f4f4f4;
    }

    .flex {
        display: flex;
    }

    .flex-col {
        flex-direction: column;
    }

    .justify-between {
        justify-content: space-between;
    }

    .justify-center {
        justify-content: center;
    }

    .justify-around {
        justify-content: space-around;
    }

    .items-center {
        align-items: center;
    }

    .container {
        width: 800px;
        margin: 0 auto;
        background: #fff;
        padding: 50px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .mr-10 {
        margin-right: 60px;
    }

    .-mt-10 {
        margin-top: -20px;
    }

    .w-50 {
        width: 50%;
    }

    .w-1\/3 {
        width: 33.333333%;
    }

    .px-10 {
        padding-left: 10px;
        padding-right: 10px;
    }

    .text-center {
        text-align: center;
    }

    .bg-blue-300 {
        background-color: #cfe2f3;
    }

    .text-blue-600 {
        color: #2c5282;
    }

    .line-height-4 {
        line-height: .6;
    }

    .text-header {
        line-height: .4;
    }

    .border-b {
        border-bottom: 1px solid #000;
        padding-bottom: 4px;
    }

    .underline {
        text-decoration: underline;
    }

    .font-bold {
        font-weight: bold;
    }

    .w-full {
        width: 100%;
    }

    .header .left {
        width: 100%;
        /* reducir el espaciado vertical del texto */
        line-height: 1;
    }

    .header .logo {
        width: 150px;
        height: 150px;
        margin-right: 10px;
    }

    .header .right {
        width: 100%;
        text-align: right;
    }

    .info p {
        margin: 5px 0;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    table,
    th,
    td {
        border: 1px solid #000;
    }

    th,
    td {
        padding: 8px;
        text-align: left;
    }

    thead {
        background-color: #f0f0f0;
    }

    tbody tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    .observaciones {
        font-size: 0.9em;
    }

    .observaciones ul {
        margin: 0;
        padding-left: 20px;
    }

    .observaciones ul li {
        margin-bottom: 5px;
    }
</style>
<body>
    <div class="container">
        <div class="header">
            <div class="left flex justify-between">
                <img src="<?php echo e(asset('images/logo_concisa.png')); ?>" alt="Logo" class="logo">
                <div>
                    <div class="right">
                        <p>No. C<strong><?php echo e($infoCotizacion['id']); ?> - <?php echo e($infoCotizacion['referencia']); ?></strong></p>
                    </div>
                    <div class="info">
                        <p>KOTON TEXTILS</p>
                        <p>7a. Av. 14-44 zona 9, Edificio La Galería, 3er Nivel, Oficina 302, Guatemala</p>
                        <p>Tel. +502 2493-3351, 3094-6441 info@sharkarstore.com</p>
                        <p>NIT 10965473-0</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="flex w-full">
            <div class="mr-10 font-bold line-height-4">
                <p>EMPRESA:</p>
                <p>DIRECCION:</p>
                <p>FECHA:</p>
                <p>NIT:</p>
            </div>
            <div class="text-header">
                <p class="w-full border-b"><?php echo e($infoCotizacion['nombre_cliente']); ?></p>
                <p class="w-full border-b"><?php echo e($infoCotizacion['direccion_cliente']??'N/A'); ?></p>
                <p class="w-full border-b"><?php echo e($infoCotizacion['dia']); ?> de <?php echo e($infoCotizacion['mes']); ?> del <?php echo e($infoCotizacion['ano']); ?></p>
                <div class="flex -mt-10">
                    <p class="w-full border-b mr-10"><?php echo e($infoCotizacion['nit_cliente']??'N/A'); ?></p>
                    <div class="flex w-50">
                        <p class="font-bold">TEL:</p>
                        <p class="w-full border-b"><?php echo e($infoCotizacion['telefono_cliente']??'N/A'); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <table>
            <thead>
                <tr class="bg-blue-300">
                    <th>PROD.</th>
                    <th>TALLA</th>
                    <th>DESCRIPCIÓN DEL INSUMO</th>
                    <th>UNI. MEDIDA</th>
                    <th>PRECIO UNIDAD</th>
                    <th>TOTAL Q</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e($infoCotizacion['categoria']); ?></td>
                    <td><?php echo e($infoCotizacion['medida']); ?></td>
                    <td><?php echo e($infoCotizacion['nombre_producto']); ?></td>
                    <td><?php echo e($infoCotizacion['cantidad']); ?></td>
                    <td><?php echo e($infoCotizacion['id_moneda']??'Q'); ?> <?php echo e(number_format($infoCotizacion['precio'],2,'.',',')); ?></td>
                    <td><?php echo e($infoCotizacion['id_moneda']??'Q'); ?> <?php echo e(number_format($infoCotizacion['total'],2,'.',',')); ?></td>
                </tr>
                <tr>
                    <td colspan="5" class="bg-blue-300"><strong>TOTAL</strong></td>
                    <td class="bg-blue-300"><strong><?php echo e($infoCotizacion['id_moneda']??'Q'); ?> <?php echo e(number_format($infoCotizacion['total'],2,'.',',')); ?></strong></td>
                </tr>
            </tbody>
        </table>

        <div class="observaciones">
            <p><strong>OBSERVACIONES:</strong></p>
            <ul>
                <li>El tiempo de garantía de la prenda es de 12 meses por daños de confección o descomposición del
                    material.</li>
                <li>El tiempo de entrega de las prendas es en 05 días hábiles desde la confirmación de la orden.</li>
                <li>El tiempo de sostenimiento de oferta es de 45 días</li>
            </ul>
        </div>

        <div class="flex items-center w-full text-center justify-center">
            <div class="px-10 flex flex-col items-center justify-center w-1/3">
                <img src="<?php echo e(asset('images/ana2.png')); ?>" alt="FIRMA1" style="width: 100px;">
                <div class="line-height-4">
                    <p>AUT.REPRESENTANTE LEGAL</p>
                    <p class="text-blue-600">Ana Batz</p>
                </div>
            </div>
            <div class="px-10 flex flex-col items-center justify-center w-1/3">
                <img src="<?php echo e(asset('images/sello2.png')); ?>" alt="SELLO" style="width: 200px;">
            </div>
            <div class="px-10 flex flex-col items-center justify-center w-1/3">
                <img src="<?php echo e(asset($infoCotizacion['firma'])); ?>" alt="FIRMA2" style="width: 100px;">
                <div class="line-height-4">
                    <p>ASESOR COMERCIAL</p>
                    <p class="text-blue-600"><?php echo e($infoCotizacion['nombre_ejecutivo']); ?></p>
                </div>
            </div>
        </div>
        <div class="w-full">
            <img src="<?php echo e(asset('images/pie.png')); ?>" alt="FORMA" class="w-full">
        </div>
    </div>
</body>
</html><?php /**PATH /home/n344795/koton.webdevgt.com/resources/views/ventas/pdf/cotizacion.blade.php ENDPATH**/ ?>