<?php $__env->startSection('content'); ?>

<form action="<?php echo e(route('ventas.guardar_cotizacion')); ?>" method="POST">
  <?php echo csrf_field(); ?>
<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('ventas.dashboard')); ?>">Cotizaciones</a></li>
            <li class="breadcrumb-item active" aria-current="page">Nueva</li>
          </ol>
        </nav>
        
          <input type="submit" href="<?php echo e(route('ventas.cliente')); ?>" class="botonColor" value="Guardar" />
      </div>
      <hr>
      <!--  
      <div class="col-md-12">
        <a type="button" href="<?php echo e(route('ventas.cotizacion')); ?>" class="botonColor">Imprimir</a>
        <a type="button" href="<?php echo e(route('ventas.cotizacion')); ?>" class="botonColorNoColor">Confirmar</a>
        <a type="button" href="<?php echo e(route('ventas.cotizacion')); ?>" class="botonColorNoColor">Cancelar</a>
      </div>
      -->
    </div>
</div>

<div id="contenedor_contenido" class="container-fluid px-lg-5">
  <div class="row">
    <div class="col-md-12">
      <h2>Nueva cotización</h2>
    </div>
    <div class="col-md-12">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cliente</label>
              <div class="col-sm-8">
                <select class="form-control" name="cliente" onchange="infoCliente(this)" id="exampleFormControlSelect1">
                  <option>Seleccione un cliente</option>
                  <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($cliente['id']); ?>"><?php echo e($cliente['nombre']); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Nit</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" id="nit" value="" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Dirección</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" id="direccion" value="" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Validez de cotización</label>
              <div class="col-sm-8">
                <input type="text" name="validez_cotizacion" class="form-control-plaintext  daterange-single" value="" placeholder="">
              </div>
            </div>
          </div>


          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Moneda</label>
              <div class="col-sm-8">
                <select class="form-control" name="id_moneda" id="exampleFormControlSelect1">
                  <option value="1">Q</option>
                  <option value="2">$</option>
                </select>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Condiciones de pago</label>
              <div class="col-sm-8">
                <select class="form-control" name="condiciones_pago" id="condiciones_pago">
                  <option>Días de crédito</option>
                  <option value="1">Contado</option>
                  <option value="2">15 días</option>
                  <option value="3">30 días</option>
                  <option value="4">45 días</option>
                  <option value="5">60 días</option>
                </select>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Condiciones de entrega</label>
              <div class="col-sm-8">
                <input type="text" name="condiciones_entrega" class="form-control-plaintext" value="" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Régimen fiscal
              </label>
              <div class="col-sm-8">
                <select class="form-control" name="regimen_fiscal" id="exampleFormControlSelect1">
                  <option value="1">Ninguno</option>
                  <option value="2">Decreto régimen 2989</option>
                </select>
              </div>
            </div>
          </div>
        </div>
        <!-- Productos -->
        <div class="row">
          <div class="col-md-12">
            <ul class="nav nav-tabs" id="myTab">
              <li class="nav-item">
                  <a href="#home" class="nav-link" data-toggle="tab">Lista del pedido</a>
              </li>
              <li class="nav-item">
                  <a href="#profile" class="nav-link" data-toggle="tab">Otra información</a>
              </li>
            </ul>
            <div class="tab-content">
              <div class="tab-pane fade" id="home">
                <table class="table">
                  <thead>
                    <tr>
                      <th scope="col">Descripción de Producto</th>
                      <th scope="col">Cantidad</th>
                      <th scope="col">Unidad de medida</th>
                      <th scope="col">Precio unitario</th>
                      <th scope="col">Impuestos</th>
                      <th scope="col">Total</th>
                    </tr>
                  </thead>
                  <tbody id="contenedorProductos">
                    <tr class="producto"> 
                      <td>
                        <select class="form-control" name="id_p[]" onchange="infoProducto(this)" id="exampleFormControlSelect1">
                          <option>Seleccione un producto</option>
                          <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($producto['id']); ?>"><?php echo e($producto['nombre']); ?></option>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                      </td>
                      <td><input type="number" onchange="calcularSubTotal(this)" name="cantidad_p[]" class="cantidad"></td>
                      <td><input class="unidad_medida"  type="text"><input class="idMedida" name="id_medida[]"  type="hidden"></td>
                      <td><input class="precio_sugerido" type="text" name="precio_p[]" onchange="calcularSubTotal(this)"></td>
                      <td><input type="text" class="impuestos"></td>
                      <td><input type="text" class="subTotal"></td>
                    </tr>
                  </tbody>
                </table>
                <a class="botonColor" onclick="nuevaFila()">Agregar producto</a>
                <hr>
                <div class="total">
                  <p>Impuestos: <span id="impuestos">0.00</span></p>
                  <p class="mostrarTotal">Total: <span id="totalTotal">0.00</span></p>
                </div>
                
              </div>
              <div class="tab-pane fade" id="profile">
                <div class="row">
                  <div class="col-md-12">
                    <br>
                    <h4>Información de envio</h4>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Almacén</label>
                      <div class="col-sm-8">
                        <input type="text" readonly class="form-control-plaintext" value="" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Política de entrega	</label>
                      <div class="col-sm-8">
                        <input type="text" readonly class="form-control-plaintext" value="" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Fecha de pedido	</label>
                      <div class="col-sm-8">
                        <input type="text" readonly class="form-control-plaintext" value="" placeholder="">
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Usuario</label>
                      <div class="col-sm-8">
                        <input type="text" readonly class="form-control-plaintext" value="" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Equipo de ventas</label>
                      <div class="col-sm-8">
                        <input type="text" readonly class="form-control-plaintext" value="" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Referencia cliente</label>
                      <div class="col-sm-8">
                        <input type="text" readonly class="form-control-plaintext" value="" placeholder="">
                      </div>
                    </div>
                  </div>
                </div>
              </div>

            </div>
        </div>
      

    </div>
  </div>
</div>
</form>
<script>
  function nuevaFila(){
    var row = document.getElementsByClassName("producto"); // find row to copy
    var table = document.getElementById("contenedorProductos"); // find table to append to
    var clone = row[0].cloneNode(true); // copy children too
    table.appendChild(clone); // add new row to end of table
    clone.getElementsByClassName('precio_sugerido')[0].value='';
    clone.getElementsByClassName('cantidad')[0].value='';
    clone.getElementsByClassName('unidad_medida')[0].value='';
    clone.getElementsByClassName('idMedida')[0].value=0;
    clone.getElementsByClassName('impuestos')[0].value='';
    clone.getElementsByClassName('subTotal')[0].value='';
  }
  function infoCliente(elemento){
    jQuery( document ).ready(function() {
      var token = '<?php echo e(csrf_token()); ?>';
      $.ajax({
        type:'POST',
        url:'<?php echo e(route('ventas.buscar_cliente')); ?>',
        headers: {'X-CSRF-TOKEN': token},
        data:{
          id_cliente:elemento.value,
        },
        success:function(data){
          $('#nit').val(data.nit);
          $('#direccion').val(data.direccion);
          $('#direccion').val(data.direccion);
          console.log('hola',data.condiciones_pago);
          $("#condiciones_pago").val(data.condiciones_pago).change();
        }
      });
    });
  }
  function calcularSubTotal(elemento){
    var padre=elemento.parentElement.parentElement;
    var precio=padre.getElementsByClassName('precio_sugerido')[0].value;
    var cantidad=padre.getElementsByClassName('cantidad')[0].value;
    console.log('precio',precio);
    console.log('cantidad',cantidad);
    var subTotal=precio*cantidad;
    var impuestos=subTotal*0.12;
    var totalImpuesto=0;
    var totalTotal=0;
    padre.getElementsByClassName('impuestos')[0].value=impuestos;
    padre.getElementsByClassName('subTotal')[0].value=impuestos+subTotal;
    //Sumar impuestos
    console.log(document.querySelectorAll('impuestos'));
    document.querySelectorAll('.impuestos').forEach(element => {
      totalImpuesto=parseFloat(totalImpuesto)+parseFloat(element.value);
    });
    document.getElementById('impuestos').innerHTML=totalImpuesto;

    document.querySelectorAll('.subTotal').forEach(element => {
      totalTotal=parseFloat(totalTotal)+parseFloat(element.value);
    });
    document.getElementById('totalTotal').innerHTML=totalTotal;
  }
  function infoProducto(elemento){
    jQuery( document ).ready(function() {
      var token = '<?php echo e(csrf_token()); ?>';
      $.ajax({
        type:'POST',
        url:'<?php echo e(route('ventas.buscar_producto')); ?>',
        headers: {'X-CSRF-TOKEN': token},
        data:{
          id_producto:elemento.value,
        },
        success:function(data){
          var padre=elemento.parentElement.parentElement;
          $(padre).find('.unidad_medida').val(data.medida.nombre);
          $(padre).find('.idMedida').val(data.medida.id);
          $(padre).find('.precio_sugerido').val(data.precio_venta);
        }
      });
    });
  }

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ventas.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\erp\resources\views/ventas/cotizacion.blade.php ENDPATH**/ ?>