<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="<?php echo e(asset('images/favicon.png')); ?>">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Scripts -->
    <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet">

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
</head>
<body>
    <div id="app">
        <nav class="navbar navbar-light">
            
            <ul class="navbar-nav ml-auto">
                <!-- Authentication Links -->
                
                    <li class="nav-item dropdown">
                        <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                            <?php echo e(Auth::user()->name); ?>

                        </a>

                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                               onclick="event.preventDefault();
                                             document.getElementById('logout-form').submit();">
                                Cerrar sesión
                            </a>

                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                <?php echo csrf_field(); ?>
                            </form>
                        </div>
                    </li>
                
            </ul>
        </nav>
        <div class="container">
            <div class="row">
                <img style="margin: auto" src="<?php echo e(asset('images/logo_concisa_t.png')); ?>" alt="">
                <div id="c_iconosDashboard" class="col-md-12">
                    <?php if($usuario==1 || $usuario>=2): ?>
                    <?php if($usuario==7 || $usuario==12): ?>
                    <a href="<?php echo e(route('ventas.dashboard_gerencia')); ?>"> 
                        <div class="link">
                            <img class="iconosDashboard" src="<?php echo e(asset('images/ventas.png')); ?>" alt="Ventas">
                            <p>Ventas</p>
                        </div>                
                    </a>
                    <?php else: ?>
                    <a href="<?php echo e(route('ventas.dashboard')); ?>">
                        <div class="link">
                            <img class="iconosDashboard" src="<?php echo e(asset('images/ventas.png')); ?>" alt="Ventas">
                            <p>Ventas</p>
                        </div>                
                    </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('compras.dashboard')); ?>">
                        <div class="link">
                            <img class="iconosDashboard" src="<?php echo e(asset('images/compra.png')); ?>" alt="Ventas">
                            <p>Compras</p>
                        </div>                
                    </a>
                    <a href="<?php echo e(route('inventario.dashboard')); ?>">
                        <div class="link">
                            <img class="iconosDashboard" src="<?php echo e(asset('images/inventario.png')); ?>" alt="Ventas">
                            <p>Almacen</p>
                        </div>                
                    </a>
                    <a href="<?php echo e(route('fabricacion.dashboard')); ?>">
                        <div class="link">
                            <img class="iconosDashboard" src="<?php echo e(asset('images/fabricacion.png')); ?>" alt="Ventas">
                            <p>Fabricación</p>
                        </div>                
                    </a>
                    <a href="<?php echo e(route('contabilidad.dashboard')); ?>">
                        <div class="link">
                            <img class="iconosDashboard" src="<?php echo e(asset('images/contabilidad.png')); ?>" alt="Ventas">
                            <p>Contabilidad</p>
                        </div>                
                    </a>
                    <a href="<?php echo e(route('ventas.dashboard')); ?>">
                        <div class="link">
                            <img class="iconosDashboard" src="<?php echo e(asset('images/ajustes.png')); ?>" alt="Ventas">
                            <p>Ajustes</p>
                        </div>                
                    </a>
                    <?php endif; ?>
                    <?php if($usuario==2): ?>
                    <a href="<?php echo e(route('fabricacion.dashboard')); ?>">
                        <div class="link">
                            <img class="iconosDashboard" src="<?php echo e(asset('images/fabricacion.png')); ?>" alt="Ventas">
                            <p>Fabricación</p>
                        </div>                
                    </a>
                    <?php endif; ?>
                    <?php if($usuario==3): ?>
                    <a href="<?php echo e(route('inventario.dashboard')); ?>">
                        <div class="link">
                            <img class="iconosDashboard" src="<?php echo e(asset('images/inventario.png')); ?>" alt="Ventas">
                            <p>Almacen</p>
                        </div>                
                    </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</body>

</html><?php /**PATH /home/cuatro5/paginawebguatemala.com/concisa/resources/views/dashboard.blade.php ENDPATH**/ ?>