<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Prueba PDF</title>
</head>
<style>
    #logo{
        width: 110px;
    }
    #contenido{
        padding-left: 10px;
        padding-right: 10px;
    }
    #fecha{
        text-align: right;
    }
    .tituloH{
        line-height: 2px;
    }
    table{
        width: 100%;
    }
    #descripcionCotizacion th, #descripcionCotizacion td{
        border: 1px solid black;
        text-align: center;
    }
    #descripcionCotizacion{
        margin-top: 25px;
        margin-bottom: 30px;
    }
    .infoPie{
        margin-top: 25px;
        text-align: center;
        margin: 0px;
    }
    .final{
        text-align: center;
        color: #666;
    }
    #firma{
        text-align: center;
    }
    #firma img{
        width: 60px;
    }
    #cotizacion{
        text-align: right;
    }
    #firma2{
        width: 40px;
    }
</style>
<body>
    <div id="contenido">
        <img id="logo" src="https://laravelrp.com/public/images/logo_concisa.png" alt="Concisa" class="img-fluid">
        <p id="fecha">Guatemala <?php echo e($infoCotizacion['dia']); ?> de <?php echo e($infoCotizacion['mes']); ?> del <?php echo e($infoCotizacion['ano']); ?></p>
        <p id="cotizacion">COTIZACIÓN: <strong><?php echo e($infoCotizacion['id']); ?> - <?php echo e($infoCotizacion['referencia']); ?></strong></p>
        <p class="tituloH">Señores:</p>
        <p class="tituloH"><strong><?php echo e($infoCotizacion['nombre_cliente']); ?></strong>  </p>
        <p class="tituloH">Atención</p>
        <p class="tituloH"><strong><?php echo e($infoCotizacion['nombre_contacto']); ?></strong></p>
        <p>Estimados Señores:</p>
        <p class="">
            Atentamente presentamos a su consideración nuestra COTIZACIÓN de los siguientes productos:
        </p>
        <table id="descripcionCotizacion">
            <thead>
                <tr>
                    <th>CANTIDAD</th>
                    <th>DESCRIPCION DE LOS PRODUCTOS</th>
                    <th>PRECIO</th>
                    <th>VALOR TOTAL</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e(number_format($infoCotizacion['cantidad'],2,'.',',')); ?> <?php echo e($infoCotizacion['medida']); ?></td>
                    <td><?php echo e($infoCotizacion['nombre_producto']); ?></td>
                    <td><?php echo e($infoCotizacion['id_moneda']??'Q'); ?> <?php echo e(number_format($infoCotizacion['precio'],2,'.',',')); ?></td>
                    <td><?php echo e($infoCotizacion['id_moneda']??'Q'); ?> <?php echo e(number_format($infoCotizacion['total'],2,'.',',')); ?></td>
                </tr>
            </tbody>
            <tfoot>
                <tr>
                    <td></td>
                    <td style="text-align: left"><strong>TOTAL</strong></td>
                    <td></td>
                    <td><?php echo e($infoCotizacion['id_moneda']??'Q'); ?> <?php echo e(number_format($infoCotizacion['total'],2,'.',',')); ?></td>
                </tr>
                <tr>
                    <td colspan="4">
                    <?php
                        require_once ('cotizaciones/NumeroALetras.php');
                        $formatter = new NumeroALetras();
                        if($infoCotizacion['id_moneda']=='Q'){
                            echo $formatter->toMoney($infoCotizacion['total'], 2, 'QUETZALES', 'CENTAVOS');
                        }else{
                            echo $formatter->toMoney($infoCotizacion['total'], 2, 'DOLARES', 'CENTAVOS');
                        }
                        
                    ?>
                    </td>
                </tr>
            </tfoot>
        </table>
        
        <?php if((int)$infoCotizacion['tipo_regimen']==1): ?>
            <p>Los precios ya incluyen IVA <br>El cliente acepta + - 10% de la cantidad de producto solicitada, la cual será facturada.</p>
        <?php endif; ?>
        <?php if((int)$infoCotizacion['tipo_regimen']==2): ?>
            <p>Los precios NO incluyen IVA Decreto régimen 2989 <br>El cliente acepta + - 10% de la cantidad de producto solicitada, la cual será facturada.</p>
        <?php endif; ?>
        <table>
            <tr>
                <td>Tiempo de entrega:</td>
                <td>Según programación y disponibilidad.</td>
            </tr>
            <tr>
                <td>Condiciones de entrega:</td>
                <td>Producto se entrega en perímetro de la ciudad capital <br>
                    La entrega se realiza 7-14 días después de la orden de producción ó inmediata según inventarios.
            </td>
            </tr>
            <tr>
                <td>Forma de pago:</td>
                <td>
                    <?php if($infoCotizacion['condicion']==1): ?>
                        Contado
                    <?php endif; ?>
                     <?php if($infoCotizacion['condicion']==2): ?>
                     15 días
                    <?php endif; ?>
                     <?php if($infoCotizacion['condicion']==3): ?>
                     30 días
                    <?php endif; ?>
                    <?php if($infoCotizacion['condicion']==4): ?>
                     45 días
                    <?php endif; ?>
                    <?php if($infoCotizacion['condicion']==5): ?>
                    60 días
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <td>OBSERVACIONES:</td>
                <td>
                    Cotización tiene un validez hasta <strong><?php echo e($infoCotizacion['fecha_validez']); ?></strong><br>
                    <?php echo e($infoCotizacion['observaciones']); ?></td>
            </tr>
        </table>
        <br>
        <p class="infoPie">Atentamente,</p>
        <p id="firma"><img  src="<?php echo e(asset($infoCotizacion['firma'])); ?>" alt="Concisa"></p>
        <p class="infoPie"><?php echo e($infoCotizacion['nombre_ejecutivo']); ?></p>
        <p class="infoPie">Ejecutivo de Ventas</p>
        <p class="infoPie">Cel. <?php echo e($infoCotizacion['celular']); ?></p>
        <p style="text-align: right">
            Vo.Bo. <br>
            <img id='firma2'  src="<?php echo e(asset('images/ok.jpg')); ?>" alt="Concisa">
        </p>
        <hr>
        <p class="final">Diagonal 6 13-46 Zona 10 Guatemala, Guatemala <br>
            Tel. 2333-5126 / 4983-9095
            </p>
    </div>
</body>
</html><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/ventas/pdf/cotizacion.blade.php ENDPATH**/ ?>