<?php $__env->startSection('content'); ?>


<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('contabilidad.dashboard_facturas')); ?>">Recibo de caja</a></li>
            <li class="breadcrumb-item active" aria-current="page">Ver</li>
          </ol>
        </nav>
      </div>
      <hr>
    </div>
</div>

<div id="contenedor_contenido" class="container-fluid px-lg-5">
  <div class="row">
    <div class="col-md-12">
      <h2>Recibo de Caja <?php echo e($recibo_caja->id); ?></h2>
    </div>
    <div class="col-md-12">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cliente</label>
              <div class="col-sm-8">
                  <p><?php echo e($recibo_caja->cliente->nombre); ?></p>
                  <input type="hidden" name="id_cliente" value="<?php echo e($recibo_caja->id_cliente); ?>">
                  
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Nit</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" id="nit" value="<?php echo e($recibo_caja->cliente->nit); ?>" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Dirección</label>
              <div class="col-sm-8">
                <p><?php echo e($recibo_caja->cliente->direccion); ?></p>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Moneda</label>
              <div class="col-sm-8">
                <select class="form-control" name="id_moneda" id="exampleFormControlSelect1">
                  <option <?php echo e($recibo_caja->cliente->id_moneda == 1 ? "selected" : ""); ?> value="1">Q</option>
                  <option <?php echo e($recibo_caja->cliente->id_moneda == 2 ? "selected" : ""); ?> value="2">$</option>
                </select>
              </div>
            </div>
          </div>


          <div class="col-md-6">

            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Condiciones de pago</label>
              <div class="col-sm-8">
                <?php if($recibo_caja->cliente->condiciones_pago == 1): ?>
                  <p>Contado</p>
                <?php endif; ?>
                <?php if($recibo_caja->cliente->condiciones_pago == 6): ?>
                  <p>8 días</p>
                <?php endif; ?>
                <?php if($recibo_caja->cliente->condiciones_pago == 2): ?>
                  <p>15 días</p>
                <?php endif; ?>
                <?php if($recibo_caja->cliente->condiciones_pago == 3): ?>
                  <p>30 días</p>
                <?php endif; ?>
                <?php if($recibo_caja->cliente->condiciones_pago == 4): ?>
                  <p>45 días</p>
                <?php endif; ?>
                <?php if($recibo_caja->cliente->condiciones_pago == 5): ?>
                  <p>60 días</p>
                <?php endif; ?>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Régimen fiscal
              </label>
              <div class="col-sm-8">
                <?php if($recibo_caja->cliente->tipo_regimen == 1): ?>
                <p>Ninguno</p>
                <?php endif; ?>
                <?php if($recibo_caja->cliente->tipo_regimen == 2): ?>
                  <p>Decreto régimen 2989</p>
                <?php endif; ?>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Número Recibo Caja</label>
              <div class="col-sm-8">
                <p><?php echo e($recibo_caja->recibo_caja_numero); ?></p>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Imagen Recibo de caja</label>
              <div class="col-sm-8">
                <a href="<?php echo e(asset("/recibo_caja/".$recibo_caja->nombre_imagen_recibo)); ?>" target='_blank'><i class="fas fa-camera"></i></a>
              </div>
            </div>
          </div>
        </div>
        <!-- Productos -->
        <div class="row">
          <div class="col-md-12">
                <table id="table_recibo" class="table">
                  <thead>
                    <tr>
                      <th scope="col">RC</th>
                      <th scope="col">Factura</th>
                      <th scope="col">Total Factura</th>
                      <th scope="col">Cheque No</th>
                      <th scope="col">Efectivo</th>
                      <th scope="col">Total</th>
                    </tr>
                  </thead>
                  <tbody id="contenedorProductos">
                    <?php $__currentLoopData = $recibo_caja->facturas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factura): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr class="items_recibo_caja"> 
                        <td><p><?php echo e($factura->ver_recibo->recibo_caja_numero); ?></p></td>
                        <td><p><?php echo e($factura->id_factura_sat); ?></p></td>
                        <td><p><?php echo e(number_format($factura->total_factura,2,'.',',')); ?></p></td>
                        <td><p><?php echo e($factura->numero_cheque??0); ?></p></td>
                        <td><p><?php echo e(number_format($factura->efectivo??0,2,'.',',')); ?></p></td>
                        <td><p><?php echo e(number_format($factura->total_cancelar,2,'.',',')); ?></p></td>
                      </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                </table>
                <hr>
                <div class="total">
                  <p>TOTAL: Q <?php echo e(number_format($recibo_caja->id_total,2,'.',',')); ?></p></p>
                </div>
                
        </div>
      

    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('contabilidad.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/contabilidad/ver_recibo_caja_v2.blade.php ENDPATH**/ ?>