<?php $__env->startSection('content'); ?>

<style>
    #logo{
        width: 140px;
    }
    #contenido{
        padding-left: 10px;
        padding-right: 10px;
    }
    #fecha{
        text-align: right;
    }
    .tituloH{
        line-height: 2px;
    }
    table{
        width: 100%;
    }
    #descripcionCotizacion th, #descripcionCotizacion td{
        border: 1px solid black;
        text-align: center;
    }
    #descripcionCotizacion{
        margin-top: 25px;
        margin-bottom: 30px;
    }
    .infoPie{
        margin-top: 25px;
        text-align: center;
        margin: 0px;
    }
    .final{
        text-align: center;
        color: #666;
    }
    #firma{
        text-align: center;
    }
    #firma img{
        width: 100px;
    }
    #cotizacion{
        text-align: right;
    }
    #firma2{
        width: 60px;
    }
    #anulado{
        position: fixed;
        z-index: 1000;
        color: red;
        font-size: 6rem;
        top: 40%;
        font-weight: 700;
        opacity: .5;
        margin-left: 33%;
    }
    .vista_ejecutivo{
        float: right;
        background: #0c9331;
        color: #fff;
        padding: 5px 10px;
        margin-top: -50px;
    }
    #info_cuenta{
        clear: both;
        display: block;
    }
</style>
<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('ventas.dashboard_gerencia')); ?>">Cotizaciones</a></li>
                <li class="breadcrumb-item active"><?php echo e($infoCotizacion['id']); ?>  - <?php echo e($infoCotizacion['referencia']); ?> <?php echo e($infoCotizacion['stock']?' - INVENTARIO':''); ?> <a id="info_cuenta" href="<?php echo e(route('contabilidad.ver_cuenta_corriente_info',$infoCotizacion['id_cliente'])); ?>" target="_blank"><i class="fas fa-search-dollar"  style="font-size: 26px;"></i></a></li>
          </ol>
          <a class="vista_ejecutivo" href="<?php echo e(route('ventas.dashboard')); ?>" title="Generar Cotización">VISTA EJECUTIVO</a>
        </nav>
        <?php if($infoCotizacion['estatus']==1): ?>
        <h3 class="text-danger" style="display: none;" id="alertaClienteMoroso">Alerta</h3>
        <div class="row">
            <div class="col-md-6">
                <form action="<?php echo e(route('ventas.ok_cotizacion2')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="stock" value="<?php echo e($infoCotizacion['stock']); ?>">
                    <div class="form-group">
                    <label for="exampleFormControlTextarea1">Observaciones: APROBADO</label>
                    <textarea class="form-control" id="exampleFormControlTextarea1" name='observaciones' rows="3"></textarea>
                    <input type="hidden" name='idCotizacion' value='<?php echo e($infoCotizacion['id']); ?>'>
                    <input type="submit" class="botonColor" name="accion" value="aprobado" /> 
                    <input type="submit" class="botonColor2" name="accion" value="rechazado" /> 
                </div>
                </form>
            </div>
        </div>
        <?php endif; ?>
      </div>
      <hr>
    </div>
</div>
<div id="contenido">
<img id="logo" src="https://laravelrp.com/public/images/logo_concisa.png" alt="Concisa" class="img-fluid">
<p id="fecha">Guatemala <?php echo e($infoCotizacion['dia']); ?> de <?php echo e($infoCotizacion['mes']); ?> del <?php echo e($infoCotizacion['ano']); ?></p>
<p id="cotizacion">COTIZACIÓN: <strong><?php echo e($infoCotizacion['id']); ?> - <?php echo e($infoCotizacion['referencia']); ?></strong></p>
<p class="tituloH">Señores:</p>
<p class="tituloH"><strong><?php echo e($infoCotizacion['nombre_cliente']); ?></strong>  </p>
<p class="tituloH">Atención</p>
<p class="tituloH"><strong><?php echo e($infoCotizacion['nombre_contacto']); ?></strong></p>
<p>Estimados Señores:</p>
<p class="">
    Atentamente presentamos a su consideración nuestra COTIZACIÓN de los siguientes productos:
</p>
<?php if($infoCotizacion['estatus']==4): ?>
    <div id="anulado">
        ARCHIVADA
    </div>
<?php endif; ?>
<?php if($infoCotizacion['estatus']==77): ?>
    <div id="anulado">
        ANULADA
    </div>
<?php endif; ?>
<table id="descripcionCotizacion">
    <thead>
        <tr>
            <th>CANTIDAD</th>
            <th>DESCRIPCION DE LOS PRODUCTOS</th>
            <th>PRECIO</th>
            <th>VALOR TOTAL</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><?php echo e(number_format($infoCotizacion['cantidad'],2,'.',',')); ?> <?php echo e($infoCotizacion['medida']); ?></td>
            <td><?php echo e($infoCotizacion['nombre_producto']); ?></td>
            <td><?php echo e($infoCotizacion['id_moneda']); ?> <?php echo e(number_format($infoCotizacion['precio'],2,'.',',')); ?></td>
            <td><?php echo e($infoCotizacion['id_moneda']); ?> <?php echo e(number_format($infoCotizacion['total'],2,'.',',')); ?></td>
        </tr>
    </tbody>
    <tfoot>
        <tr>
            <td></td>
            <td style="text-align: left"><strong>TOTAL</strong></td>
            <td></td>
            <td><?php echo e($infoCotizacion['id_moneda']); ?> <?php echo e(number_format($infoCotizacion['total'],2,'.',',')); ?></td>
        </tr>
        <tr>
            <td colspan="4">
            <?php
                require_once ('cotizaciones/NumeroALetras.php');
                $formatter = new NumeroALetras();
                if($infoCotizacion['id_moneda']=='Q'){
                    echo $formatter->toMoney($infoCotizacion['total'], 2, 'QUETZALES', 'CENTAVOS');
                }else{
                    echo $formatter->toMoney($infoCotizacion['total'], 2, 'DOLARES', 'CENTAVOS');
                }
            ?>
            </td>
        </tr>
    </tfoot>
</table>

<?php if((int)$infoCotizacion['tipo_regimen']==1): ?>
    <p>Los precios ya incluyen IVA <br>El cliente acepta + - 10% de la cantidad de producto solicitada, la cual será facturada.</p>
<?php endif; ?>
<?php if((int)$infoCotizacion['tipo_regimen']==2): ?>
    <p>Los precios NO incluyen IVA Decreto régimen 2989 <br>El cliente acepta + - 10% de la cantidad de producto solicitada, la cual será facturada.</p>
<?php endif; ?>
<table>
    <tr>
        <td>Tiempo de entrega:</td>
        <td>Según programación y disponibilidad.</td>
    </tr>
    <tr>
        <td>Condiciones de entrega:</td>
        <td>Producto se entrega en perímetro de la ciudad capital <br>
            La entrega se realiza 7-14 días después de la orden de producción ó inmediata según inventarios.
    </td>
    </tr>
    <tr>
        <td>Forma de pago:</td>
        <td>
            <?php if($infoCotizacion['condicion']==1): ?>
                Contado
            <?php endif; ?>
             <?php if($infoCotizacion['condicion']==2): ?>
             15 días
            <?php endif; ?>
             <?php if($infoCotizacion['condicion']==3): ?>
             30 días
            <?php endif; ?>
            <?php if($infoCotizacion['condicion']==4): ?>
             45 días
            <?php endif; ?>
            <?php if($infoCotizacion['condicion']==5): ?>
            60 días
            <?php endif; ?>
        </td>
    </tr>
    <tr>
        <td>OBSERVACIONES:</td>
        <td>
            Cotización tiene un validez hasta <strong><?php echo e($infoCotizacion['fecha_validez']); ?></strong><br>
            <?php echo e($infoCotizacion['observaciones']); ?></td>
    </tr>
</table>
<br>
<p class="infoPie">Atentamente,</p>
<p id="firma"><img  src="<?php echo e($infoCotizacion['firma']); ?>" alt="Concisa"></p>
<p class="infoPie"><?php echo e($infoCotizacion['nombre_ejecutivo']); ?></p>
<p class="infoPie">Ejecutivo de Ventas</p>
<p class="infoPie">Cel. <?php echo e($infoCotizacion['celular']); ?></p>
<p style="text-align: right">
    Vo.Bo. <br>
    <img id='firma2'  src="<?php echo e(asset('images/ok.jpg')); ?>" alt="Concisa">
</p>
<hr>
<p class="final">Diagonal 6 13-46 Zona 10 Guatemala, Guatemala <br>
    Tel. 2333-5126 / 4983-9095
    </p>
</div>

<script>
    var cliente = <?php echo e($infoCotizacion['id_cliente']); ?>;

    function infoCliente(elemento) {
        jQuery(document).ready(function() {
            var token = '<?php echo e(csrf_token()); ?>';
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route('ventas.buscar_cliente')); ?>',
                headers: {
                    'X-CSRF-TOKEN': token
                },
                data: {
                    id_cliente: elemento,
                },
                success: function(data) {
                    if (parseInt(data.mora) > 0) {
                        $('#alertaClienteMoroso').css('display', 'block');
                        document.getElementById('alertaClienteMoroso').textContent =
                            'Cliente con mora de ' + data.mora + ' días';
                    }
                }
            });
        });
    }

    document.addEventListener("DOMContentLoaded", function(event) {
        infoCliente(cliente);
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ventas.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/ventas/cotizacion_ok.blade.php ENDPATH**/ ?>