<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Prueba PDF</title>
</head>
<style>
    * {
        font-size: 15px;
    }
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 20px;
    }

    .container {
        width: 800px;
        margin: 0 auto;
        background: #fff;
        padding: 50px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .header table,
    .info table {
        width: 100%;
    }

    .header .logo {
        width: 150px;
        height: 150px;
    }

    .info p {
        margin: 5px 0;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    table,
    th,
    td {
        border: 1px solid #000;
    }

    th,
    td {
        padding: 8px;
        text-align: left;
    }

    thead {
        background-color: #f0f0f0;
    }

    tbody tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    .observaciones {
        font-size: 0.9em;
    }

    .observaciones ul {
        margin: 0;
        padding-left: 20px;
    }

    .observaciones ul li {
        margin-bottom: 5px;
    }

    .text-blue-600 {
        color: #2c5282;
    }

    .bg-blue-300 {
        background-color: #cfe2f3;
    }
</style>

<body>
    <div class="">
        <div class="header">
            <table width="100%" style="border: none; border-collapse: collapse;">
                <tr style="border: none;">
                    <td style="width: 30%;border: none;">
                        <img src="https://koton.webdevgt.com/public/images/logo_concisa.png" alt="Logo"
                            class="logo">
                    </td>
                    <td style="width: 70%; line-height: .4;border: none;">
                        <p style="text-align: right;">No. C<strong><?php echo e($infoCotizacion['id']); ?> - <?php echo e($infoCotizacion['referencia']); ?></strong></p>
                        <p>KOTON TEXTILS</p>
                        <p>7a. Av. 14-44 zona 9, Edificio La Galería, 3er Nivel</p>
                        <p>Oficina 302, Guatemala</p>
                        <p>Tel. +502 2493-3351, 3094-6441 info@sharkarstore.com</p>
                        <p>NIT 10965473-0</p>
                    </td>
                </tr>
            </table>
        </div>

        <div class="info">
            <table width="100%" style="border: none; border-collapse: collapse;">
                <tr style="border: none;">
                    <td style="width: 20%; font-weight: bold;border: none;">EMPRESA:</td>
                    <td style="width: 80%; border-bottom: 1px solid #000;"><?php echo e($infoCotizacion['nombre_cliente']); ?></td>
                </tr>
                <tr style="border: none;">
                    <td style="width: 20%; font-weight: bold;border: none;">DIRECCION:</td>
                    <td style="width: 80%; border-bottom: 1px solid #000;">
                        <?php echo e($infoCotizacion['direccion_cliente'] ?? 'N/A'); ?></td>
                </tr>
                <tr style="border: none;">
                    <td style="width: 20%; font-weight: bold;border: none;">FECHA:</td>
                    <td style="width: 80%; border-bottom: 1px solid #000;"><?php echo e($infoCotizacion['dia']); ?> de
                        <?php echo e($infoCotizacion['mes']); ?> del
                        <?php echo e($infoCotizacion['ano']); ?></td>
                </tr>
                <tr style="border: none;">
                    <td style="width: 20%; font-weight: bold;border: none;">NIT:</td>
                    <td style="width: 30%; border-bottom: 1px solid #000;"><?php echo e($infoCotizacion['nit_cliente'] ?? 'N/A'); ?>

                    </td>
                    <td style="width: 10%; font-weight: bold;border: none;">TEL:</td>
                    <td style="width: 40%; border-bottom: 1px solid #000;">
                        <?php echo e($infoCotizacion['telefono_cliente'] ?? 'N/A'); ?></td>
                </tr>
            </table>
        </div>

        <table>
            <thead>
                <tr class="bg-blue-300">
                    <th>PROD.</th>
                    <th>TALLA</th>
                    <th>DESCRIPCIÓN DEL INSUMO</th>
                    <th>UNI. MEDIDA</th>
                    <th>PRECIO UNIDAD</th>
                    <th>TOTAL Q</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e($infoCotizacion['categoria']); ?></td>
                    <td>A LA MEDIDA</td>
                    <td><?php echo e($infoCotizacion['nombre_producto']); ?></td>
                    <td><?php echo e($infoCotizacion['cantidad']); ?></td>
                    <td><?php echo e($infoCotizacion['id_moneda'] ?? 'Q'); ?>

                        <?php echo e(number_format($infoCotizacion['precio'], 2, '.', ',')); ?>

                    </td>
                    <td><?php echo e($infoCotizacion['id_moneda'] ?? 'Q'); ?>

                        <?php echo e(number_format($infoCotizacion['total'], 2, '.', ',')); ?>

                    </td>
                </tr>
                <tr>
                    <td colspan="5" class="bg-blue-300"><strong>TOTAL</strong></td>
                    <td class="bg-blue-300"><strong><?php echo e($infoCotizacion['id_moneda'] ?? 'Q'); ?>

                            <?php echo e(number_format($infoCotizacion['total'], 2, '.', ',')); ?></strong></td>
                </tr>
            </tbody>
        </table>

        <div class="observaciones">
            <p><strong>OBSERVACIONES:</strong></p>
            <ul>
                <li>El tiempo de garantía de la prenda es de 12 meses por daños de confección o descomposición del
                    material.</li>
                <li>El tiempo de entrega de las prendas es en 05 días hábiles desde la confirmación de la orden.</li>
                <li>El tiempo de sostenimiento de oferta es de 45 días</li>
            </ul>
        </div>

        <div class="signatures">
            <table width="100%">
                <tr>
                    <td style="width: 33%; text-align: center;">
                        <img src="https://koton.webdevgt.com/public/images/ana2.png" alt="FIRMA1"
                            style="width: 100px;">
                        <p>AUT.REPRESENTANTE LEGAL</p>
                        <p class="text-blue-600">Ana Batz</p>
                    </td>
                    <td style="width: 33%; text-align: center;">
                        <img src="https://koton.webdevgt.com/public/images/sello2.png" alt="SELLO"
                            style="width: 200px;">
                    </td>
                    <td style="width: 33%; text-align: center;">
                        <img src="https://koton.webdevgt.com/public/images/beatriz.png"
                            alt="FIRMA2" style="width: 100px;">
                        <p>ASESOR COMERCIAL</p>
                        <p class="text-blue-600"><?php echo e($infoCotizacion['nombre_ejecutivo']); ?></p>
                    </td>
                </tr>
            </table>
        </div>
        <div class="footer">
            <img src="https://koton.webdevgt.com/public/images/pie.png" alt="FORMA" style="width: 100%;">
        </div>
    </div>
</body>

</html>
<?php /**PATH /home/n344795/koton.webdevgt.com/resources/views/ventas/pdf/cotizacion.blade.php ENDPATH**/ ?>