@extends('layouts.app')

@section('content')
    @extends('ventas.menu')

    <div id="contenedor_interno" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">

                        @if (auth()->user()->id == 7 || Auth::user()->id == 12)
                            <li class="breadcrumb-item"><a href="{{ route('ventas.dashboard_produccion_gerencia') }}">Ordenes
                                    de Producción</a></li>
                        @else
                            <li class="breadcrumb-item"><a href="{{ route('ventas.dashboard_produccion') }}">Ordenes de
                                    Producción</a></li>
                        @endif

                        <li class="breadcrumb-item active" aria-current="page">Ver</li>
                    </ol>
                </nav>
            </div>
            <hr>
        </div>
    </div>
    <form action="{{ route('ventas.orden_produccion_ok2', $op->id) }}" method="POST" enctype="multipart/form-data">
        <div id="contenedor_contenido" class="container-fluid px-lg-5">
            <div class="row">
                <div class="col-md-12">
                    <h2> Orden de Producción: OP{{ $op->id }} <a
                            href="{{ route('contabilidad.ver_cuenta_corriente_info', $op->cliente->id) }}"
                            target="_blank"><i class="fas fa-search-dollar" style="font-size: 26px;"></i></a></h2>

                    @csrf
                    <div class="form-group">
                        <label for="exampleFormControlTextarea1">Observaciones</label>
                        <textarea class="form-control" id="exampleFormControlTextarea1" name='comentario_ing' rows="3">{{ $op->comentario_ing }}</textarea>
                        <input type="submit" class="botonColor2" value="ACTUALIZAR" />
                    </div>

                </div>

                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Es para inventario</label>
                                <div class="col-sm-8">
                                    <input class="form-check-input" {{ $op->inventario == 1 ? 'checked' : '' }}
                                        type="checkbox" id="gridCheck" name="inventario" value="1">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Cliente</label>
                                <div class="col-sm-8">
                                    <p class="inputText">{{ $op->cliente->nombre ?? 'Inventario' }}</p>
                                    <input type="hidden" class="form-control-plaintext" name="id_cliente"
                                        value="{{ $op->id_cliente }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Producto</label>
                                <div class="col-sm-8">
                                    <p class="inputText">{{ $op->producto->nombre }}</p>
                                    <input type="hidden" class="form-control-plaintext" name="id_producto"
                                        value="{{ $op->id_producto }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Cantidades para producir</label>
                                <div class="col-sm-8">
                                    <input type="text" id="cantidad" class="form-control-plaintext" name="cantidad"
                                        value="{{ $op->cantidad }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Unidad de medida</label>
                                <div class="col-sm-8">
                                    <input type="text" id="cantidad" readonly class="form-control-plaintext"
                                        name="unidad_medida" value="{{ $op->producto->medida->nombre }}" placeholder="">
                                </div>
                            </div>
                            @if ($op->fecha_entrega)
                                <div class="form-group row">
                                    <label for="" class="col-sm-4 col-form-label">Fecha Planificada
                                        Producción:</label>
                                    <div class="col-sm-8">
                                        <input type="text" readonly class="form-control-plaintext daterange-single"
                                            name="fecha_entrega" value="{{ date('d-m-Y', strtotime($op->fecha_entrega)) }}"
                                            placeholder="">
                                    </div>
                                </div>
                            @endif
                            {{-- <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Lista de materiales</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly class="form-control-plaintext" name="lista_materiales"
                                        value="{{ $op->lista_materiales }}" placeholder="">
                                </div>
                            </div> --}}
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Condiciones de entrega</label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="condiciones_entrega" id="" cols="30" rows="4" required
                                        readonly>{{ $op->condiciones_entrega }}</textarea>
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6">

                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Vendedor</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly class="form-control-plaintext"
                                        value="{{ $op->cliente->info_ejecutivo->name ?? 'Inventario' }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Número de cotización</label>
                                <div class="col-sm-8">
                                    <a href="{{ asset('/cotizaciones/CO_' . $op->id_cotizacion_producto) }}.pdf"
                                        target='_blank'><i class="fas fa-camera"></i>
                                        {{ $op->id_cotizacion_producto }}</a>
                                    <input type="hidden" class="form-control-plaintext"
                                        value="CO{{ $op->id_cotizacion_producto }}" placeholder="">
                                    <input type="hidden" name="id_cotizacion" value="{{ $op->id_cotizacion }}">
                                    <input type="hidden" name="id_cotizacion_producto"
                                        value="{{ $op->id_cotizacion_producto }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Número de orden compra</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="numero_oc"
                                        value="{{ $op->numero_oc }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Lugar de Entrega</label>
                                <div class="col-sm-8">
                                    <input id="lugar_entrega" name="lugar_entrega" type="text"
                                        class="form-control-plaintext" value="{{ $op->lugar_entrega }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Fecha de Entrega Planificada</label>
                                <div class="col-sm-8">
                                    <input type="date" id="fecha_entrega_planificada" name="fecha_entrega_planificada"
                                        class="form-control-plaintext" value="{{ $op->fecha_prevista }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Tipo de Producto</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="tipo_producto"
                                        value="{{ $op->micras }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Detalle Etnico</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="detalle_etnico"
                                        value="{{ $op->caracteristicas }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Tipo de Tela</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="tipo_tela"
                                        value="{{ $op->lista_materiales }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Diseño de la prenda</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="diseno_prenda"
                                        value="{{ $op->diseno_prenda }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Notas Importantes</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="notas_importantes"
                                        value="{{ $op->observaciones }}" placeholder="">
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-md-12">
                            <h2>Datos de la prenda</h2>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Genero</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="genero_prenda"
                                        value="{{ $detalleOrden->genero }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Talla</label>
                                <div class="col-sm-8">
                                    <input id="talla_prenda" name="talla_prenda" type="text"
                                        class="form-control-plaintext" value="{{ $detalleOrden->talla }}"
                                        placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Personalizacion</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="personalizacion_prenda"
                                        value="{{ $detalleOrden->personalizacion }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Bordados</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="bordado_prenda"
                                        value="{{ $detalleOrden->bordados }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Serigrafia</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="serigrafia_prenda"
                                        value="{{ $detalleOrden->serigrafia }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Sublimacion</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="sublimacion_prenda"
                                        value="{{ $detalleOrden->sublimacion }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Color</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="color_prenda"
                                        value="{{ $detalleOrden->color }}" placeholder="">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Ilustraciones actuales</label>
                                <div class="col-sm-8">
                                    <ul>
                                        @if (is_array($detalleOrden->ilustraciones_prenda) && count($detalleOrden->ilustraciones_prenda) > 0)
                                            @foreach ($detalleOrden->ilustraciones_prenda as $index => $ilustracion)
                                                <li>
                                                    <a target="_blank"
                                                        href="{{ asset('storage/orden_produccion/ilustraciones/' . $ilustracion) }}">{{ $index + 1 }}.
                                                        VER IMAGEN</a>
                                                </li>
                                            @endforeach
                                        @else
                                            <li>No hay ilustraciones disponibles</li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Logos actuales</label>
                                <div class="col-sm-8">
                                    <ul>
                                        @if (is_array($detalleOrden->logos_prenda) && count($detalleOrden->logos_prenda) > 0)
                                            @foreach ($detalleOrden->logos_prenda as $index => $logo)
                                                <li>
                                                    <a target="_blank"
                                                        href="{{ asset('storage/orden_produccion/logos/' . $logo) }}">{{ $index + 1 }}.
                                                        VER IMAGEN</a>
                                                </li>
                                            @endforeach
                                        @else
                                            <li>No hay logos disponibles</li>
                                        @endif
                                    </ul>
                                    <a class="btn btn-primary" onclick="$('#inputs-images').slideToggle();">Actualizar
                                        Imagenes</a>
                                </div>
                            </div>
                            <div id="inputs-images" style="display: none;">
                                <div class="form-group row">
                                    <label for="" class="col-sm-4 col-form-label">Nuevas Ilustraciones de la
                                        prenda</label>
                                    <div class="col-sm-8">
                                        <input type="file" class="form-control-file" id="referencia_prenda_file"
                                            name="referencia_prenda[]" multiple
                                            onchange="previewImages('referencia_prenda_file', 'preview_referencia_prenda')">
                                        <div id="preview_referencia_prenda" class="mt-2"></div>
                                        <button type="button" class="btn btn-secondary mt-2"
                                            onclick="clearImages('referencia_prenda_file', 'preview_referencia_prenda')">Limpiar</button>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="" class="col-sm-4 col-form-label">Nuevos Logos en la
                                        prenda</label>
                                    <div class="col-sm-8">
                                        <input type="file" class="form-control-file" id="logos_prenda_file"
                                            name="logos_prenda[]" multiple
                                            onchange="previewImages('logos_prenda_file', 'preview_logos_prenda')">
                                        <div id="preview_logos_prenda" class="mt-2"></div>
                                        <button type="button" class="btn btn-secondary mt-2"
                                            onclick="clearImages('logos_prenda_file', 'preview_logos_prenda')">Limpiar</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <h3 style="text-align: center">ENTREGAS PARCIALES</h3>
                    </div>
                    <div class="col-md-12">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">Producto</th>
                                    <th scope="col">Cantidad</th>
                                    <th scope="col">Unidad de medida</th>
                                    <th scope="col">Fecha</th>
                                    <th scope="col">Observación</th>
                                </tr>
                            </thead>
                            <tbody id="contenedorProductos">

                                @foreach ($opParciales as $opParcial)
                                    <tr>

                                        <td>{{ $opParcial->op->producto->nombre }}</td>
                                        <td>{{ $opParcial->cantidad }}</td>
                                        <td>{{ $opParcial->op->producto->medida->nombre ?? '' }}</td>
                                        <td>{{ date('d/m/Y', strtotime($opParcial->created_at)) }}</td>
                                        <td>{{ $opParcial->observaciones }}</td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </form>
    <script>
        // var kgs_millar = document.getElementById('kgs_millar');
        // materialProcesar(kgs_millar)

        function nuevaFila() {
            var row = document.getElementsByClassName("producto"); // find row to copy
            console.log(row);
            var table = document.getElementById("contenedorProductos"); // find table to append to
            var clone = row[0].cloneNode(true); // copy children too
            table.appendChild(clone); // add new row to end of table
        }

        // function materialProcesar(element) {

        //     var cantidad = document.getElementById('cantidad').value;
        //     var kgMillar = element.value;
        //     var total = parseFloat(kgMillar) * parseFloat(cantidad);
        //     document.getElementById('kgProcesar').value = total.toFixed(2);
        //     console.log(total);

        // }

        function previewImages(inputId, previewId) {
            var input = document.getElementById(inputId);
            var preview = document.getElementById(previewId);
            preview.innerHTML = '';

            for (var i = 0; i < input.files.length; i++) {
                var file = input.files[i];
                var reader = new FileReader();

                reader.onload = function(e) {
                    var img = document.createElement('img');
                    img.setAttribute('src', e.target.result);
                    img.setAttribute('class', 'img-thumbnail mr-2 mb-2');
                    img.style.height = '100px'; // Ajusta la altura de la previsualización
                    preview.appendChild(img);
                }

                reader.readAsDataURL(file);
            }
        }

        function clearImages(inputId, previewId) {
            var input = document.getElementById(inputId);
            var preview = document.getElementById(previewId);
            input.value = '';
            preview.innerHTML = '';
        }
    </script>
@endsection
