@extends('layouts.app')

@section('content')
@extends('inventario.menu')
<div id="contenedor-dashboard" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <h2> Salida Inventario Materia Prima</h2>
      <a type="button" href="{{route('inventario.ajuste_inventario_prima')}}" class="botonColorVerde">Salidas de Inventario</a>
    </div>
  </div>
  <div class="col-md-12">
    <br>
    <br>
    <table id="example" class="display" style="width:100%">
      <thead>
        <tr>
          <td>ID</td>
          <td>Fecha</td>
          <td>Producto</td>
          <td>Cantidad</td>
          <td>Observación</td>
        </tr>
      </thead>
      <tbody>      
        @foreach ($inventario as $op)
          @if($op->total>0)
            <tr>
              <td>{{$op->id_producto}}</td>
              <td>{{date("d/m/Y h:i:s", strtotime($op->created_at))}}</td>
              <td>{{$op->producto->nombre}}</td>
              <td>{{number_format(($op->total),2,'.',',')}}</td>
              <td>{{$op->observaciones}}</td>
            </tr>
            @endif
        @endforeach
      </tbody>
  </table>
  </div>
</div>


<script>
  $( function() {
    var token = '{{ csrf_token() }}';
    $('.entragasParciales').each(function(){
      $(this).click(function(){
        var cantidad_total=$(this).attr('data-cantidad_total');
        var id_producto=$(this).attr('data-id_producto');
        
        
        $('#cantidad').val(cantidad_total);
        $('#id_producto').val(id_producto);
        $('#cantidad_total').val(cantidad_total);      
      })
    })
    $('.entragasParciales2').each(function(){
      $(this).click(function(){
        var cantidad_total=$(this).attr('data-cantidad_total');
        var id_producto=$(this).attr('data-id_producto');
        
        
        $('#cantidad2').val(cantidad_total);
        $('#id_producto2').val(id_producto);
        $('#cantidad_total2').val(cantidad_total);      
      })
    })
    $('#btnEntraParcial').click(function(){
      $(this).attr('disabled','disabled');
      var cantidad=parseInt($('#cantidad').val());
      var cantidad_total=parseInt($('#cantidad_total').val());
      var id_cliente=$('select[name=id_cliente] option').filter(':selected').val();
      var id_producto=$('#id_producto').val();
      console.log('cantidad',cantidad);
      console.log('cantidad2',cantidad_total);
      if(cantidad_total<cantidad){
        alert('No puedes ingresar una cantidad mayor que el inventario '+cantidad_total);
        $('#btnEntraParcial').removeAttr('disabled');
        return false;
      }
      if(id_cliente=='Seleccione un cliente'){
        alert('Debes seleccionar un cliente');
        $('#btnEntraParcial').removeAttr('disabled');
        return false;
      }
      $.ajax({
        type:'POST',
        url:'{{ route('inventario.salida_almacen_ajax_inventario') }}',
        headers: {'X-CSRF-TOKEN': token},
        data:{
            cantidad:cantidad,
            id_producto:id_producto,
            id_cliente:id_cliente,
            observaciones:$('#observaciones2').val(),
        },
        success:function(data){
          $('#entregaAlmacen').modal('hide');
          alert('Se genero el envío');
          location.reload(true);
        }
      });
    })
  
    $('#btnEntraParcialEliminar').click(function(){
      $(this).attr('disabled','disabled');
      var cantidad=parseInt($('#cantidad2').val());
      var cantidad_total=parseInt($('#cantidad_total2').val());
      var id_producto=$('#id_producto2').val();
  
      if(cantidad_total<cantidad){
        alert('No puedes ingresar una cantidad mayor que el inventario '+cantidad_total);
        $('#btnEntraParcialEliminar').removeAttr('disabled');
        return false;
      }
      
      $.ajax({
        type:'POST',
        url:'{{ route('inventario.salida_almacen_ajax_inventario_eliminar') }}',
        headers: {'X-CSRF-TOKEN': token},
        data:{
            cantidad:cantidad,
            id_producto:id_producto,
            observaciones:$('#observaciones').val(),
        },
        success:function(data){
          $('#borrarAlmacen').modal('hide');
          location.reload(true);
        }
      });
    })
  });
  </script>
  @endsection