@extends('layouts.app')

@section('content')
    @extends('inventario.menu')
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Inventario Insumos y accesorios</h2>
            </div>
        </div>
        <div class="col-md-12">
            <br>
            <br>
            <table id="example" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>ID</td>
                        <td>Ultima Actualizacion</td>
                        <td>Descripcion</td>
                        <td>Estilo</td>
                        <td>Unidad de Medida</td>
                        <td>Talla</td>
                        <td>Color</td>
                        <td>Disponible</td>
                        <td>Pendiente de Ingreso</td>
                        <td>Observaciones</td>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($inventario as $insumo)
                        @php
                            $disponible = ($insumo->cantidad_recibida ?? 0) - ($insumo->entregado ?? 0);
                            $pendiente_ingreso = ($insumo->cantidad_esperada ?? 0) - ($insumo->cantidad_recibida ?? 0);
                        @endphp
                        <tr>
                            <td>{{ $insumo->id }}</td>
                            <td>{{ $insumo->created_at->format('d/m/Y, H:i') }}</td>
                            <td>{{ $insumo->descripcion }}</td>
                            <td>{{ $insumo->estilo }}</td>
                            <td>{{ $insumo->unidadMedida?->nombre }}</td>
                            <td>{{ $insumo->talla?->nombre }}</td>
                            <td>{{ $insumo->color?->nombre }}</td>
                            <td>{{ $disponible }}</td>
                            <td>{{ $pendiente_ingreso }}</td>
                            <td>{{ $insumo->observaciones }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
