@extends('layouts.app')

@section('content')
    @extends('inventario.menu')
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Inventario Insumos y Accesorios</h2>
                <a type="button" href="{{ route('inventario.ingreso_insumo') }}" class="btn btn-primary">Registrar
                    Ingreso</a>
            </div>
        </div>
        @php
            $estadosColores = [
                1 => 'success',
                2 => 'warning',
                3 => 'info',
                4 => 'success',
                99 => 'danger',
                999 => 'danger',
            ];
        @endphp
        <div class="col-md-12">
            <br>
            <table id="example" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>Correlativo</td>
                        <td>Descripcion</td>
                        <td>Cliente</td>
                        <td>PO</td>
                        <td>Fecha</td>
                        <td>Linea de negocio</td>
                        <td>Estado</td>
                        <td>Observaciones</td>
                        <td>Acciones</td>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($inventarioInsumos as $insumo)
                        @php
                            $cantidadDisponible =
                                $insumo->detalle->sum('cantidad_recibida') - $insumo->detalle->sum('entregado');
                        @endphp
                        <tr>
                            <td>
                                INV-{{ $insumo->id }}
                            </td>
                            <td>
                                <a href="{{ route('inventario.detalle_insumo', $insumo->id) }}"
                                    class="d-flex justify-content-center align-items-center">{{ $insumo->descripcion }}

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                        stroke-linecap="round" stroke-linejoin="round"
                                        class="icon icon-tabler icons-tabler-outline icon-tabler-eye ml-2">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                                        <path
                                            d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" />
                                    </svg>
                                </a>
                            </td>
                            <td>
                                {{ $insumo->cliente->nombre }}
                            </td>
                            <td>
                                {{ $insumo->po }}
                            </td>
                            <td>
                                {{ \Carbon\Carbon::parse($insumo->fecha_ingreso)->format('d/m/Y') }}
                            </td>
                            <td>
                                @php
                                    $lineaNegocioNombre = match ($insumo->linea_negocio_id) {
                                        1 => 'Maquila',
                                        2 => 'KOTON TEXTILES',
                                        3 => 'SHARKAR',
                                        default => 'Desconocido', // Opcional: manejar caso por defecto
                                    };

                                    echo $lineaNegocioNombre;
                                @endphp
                            </td>
                            <td class="alert alert-{{ $estadosColores[$insumo->estado] }}">
                                @php
                                    $estado = match ($insumo->estado) {
                                        1 => 'Ingreso Completo',
                                        2 => 'Ingreso Incompleto',
                                        3 => 'Salida Parcial',
                                        4 => 'Salida Completa',
                                        99 => 'Solicitud de Anulación',
                                        999 => 'Anulado',
                                        default => 'Desconocido', // Opcional: manejar caso por defecto
                                    };

                                    echo $estado;
                                @endphp
                            </td>
                            <td>
                                {{ $insumo->observaciones }}
                            </td>
                            <td class="d-flex justify-content-center align-items-center">
                                {{-- <button class="btn" onclick="verDetalle({{ $insumo->id }})">
                                    <a>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-eye">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                                            <path
                                                d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" />
                                        </svg>
                                    </a>
                                </button> --}}
                                @if ($insumo->imagen)
                                    <button class="btn" title="Ver Imagen Adjunta">
                                        <a href="/storage/inventarios/{{ $insumo->imagen }}" target="_blank">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="icon icon-tabler icons-tabler-outline icon-tabler-camera-plus">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path
                                                    d="M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5" />
                                                <path d="M16 19h6" />
                                                <path d="M19 16v6" />
                                                <path d="M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0" />
                                            </svg>
                                        </a>
                                    </button>
                                @endif
                                @if ($insumo->reclamo && $insumo->estado != 1)
                                    <button class="btn">
                                        <a href="{{ route('inventario.reclamo_insumo', $insumo->id) }}">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="icon icon-tabler icons-tabler-outline icon-tabler-file-invoice">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path d="M14 3v4a1 1 0 0 0 1 1h4" />
                                                <path
                                                    d="M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z" />
                                                <path d="M9 7l1 0" />
                                                <path d="M9 13l6 0" />
                                                <path d="M13 17l2 0" />
                                            </svg>
                                        </a>
                                    </button>
                                @endif
                                @if ($insumo->estado < 3)
                                    <button class="btn">
                                        <a onclick="solicitudAnulacion()">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="icon icon-tabler icons-tabler-outline icon-tabler-cancel">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path d="M3 12a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" />
                                                <path d="M18.364 5.636l-12.728 12.728" />
                                            </svg>
                                        </a>
                                    </button>
                                @endif
                                @if ($cantidadDisponible > 0)
                                    <button class="btn">
                                        <a onclick="procesarSalida({{ $insumo->id }})">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="icon icon-tabler icons-tabler-outline icon-tabler-stack-pop">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path d="M7 9.5l-3 1.5l8 4l8 -4l-3 -1.5" />
                                                <path d="M4 15l8 4l8 -4" />
                                                <path d="M12 11v-7" />
                                                <path d="M9 7l3 -3l3 3" />
                                            </svg>
                                        </a>
                                    </button>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    @foreach ($inventarioInsumos as $insumo)
        <!-- Modal PROCESAR SALIDA-->
        <div class="modal fade" id="procesarSalidaModal-{{ $insumo->id }}" tabindex="-1"
            aria-labelledby="procesarSalidaModalLabel" aria-hidden="true">
            <div class="modal-dialog" style="max-width:1200px !important;">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="procesarSalidaModalLabel">Procesar Salida</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route('inventario.entrega_parcial_insumo') }}" method="POST">
                        @csrf
                        <div class="modal-body">
                            <div id="step2">
                                <h5>Datos de Ingreso</h5>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <td>Correlativo</td>
                                            <td>Descripcion</td>
                                            <td>Cliente</td>
                                            <td>PO</td>
                                            <td>Fecha</td>
                                            <td>Linea de negocio</td>
                                            <td>Estado</td>
                                            <td>Observaciones</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>{{ $insumo->id }}</td>
                                            <td>{{ $insumo->descripcion }}</td>
                                            <td>{{ $insumo->cliente->nombre }}</td>
                                            <td>{{ $insumo->po }}</td>
                                            <td>{{ \Carbon\Carbon::parse($insumo->fecha_ingreso)->format('d/m/Y') }}</td>
                                            <td> @php
                                                $lineaNegocioNombre = match ($insumo->linea_negocio_id) {
                                                    1 => 'Maquila',
                                                    2 => 'KOTON TEXTILES',
                                                    3 => 'SHARKAR',
                                                    default => 'Desconocido', // Opcional: manejar caso por defecto
                                                };

                                                echo $lineaNegocioNombre;
                                            @endphp</td>
                                            <td> @php
                                                $estado = match ($insumo->estado) {
                                                    1 => 'Ingreso Completo',
                                                    2 => 'Ingreso Incompleto',
                                                    3 => 'Salida Parcial',
                                                    4 => 'Salida Completa',
                                                    99 => 'Solicitud de Anulación',
                                                    999 => 'Anulado',
                                                    default => 'Desconocido', // Opcional: manejar caso por defecto
                                                };
                                                echo $estado;
                                            @endphp</td>
                                            <td>
                                                {{ $insumo->observaciones }}
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <h5>Detalle de Ingreso</h5>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Cantidad a Entregar</th>
                                            <th scope="col" style='min-width: 300px;'>Descripción</th>
                                            <th scope="col">Unidad de medida</th>
                                            <th scope="col">Cantidad Disponible</th>
                                            <th scope="col">Cantidad Entregada</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($insumo->detalle as $detalle)
                                            @php
                                                $cantidadDisponible = $detalle->cantidad_recibida - $detalle->entregado;
                                            @endphp
                                            <tr>
                                                <td>
                                                    <input type="number" class="hidden" name="idsDetalle[]"
                                                        value="{{ $detalle->id }}" hidden>
                                                    <input type="number" class="form-control" name="cantidad_entregar[]"
                                                        value="{{ $cantidadDisponible }}"
                                                        max="{{ $cantidadDisponible }}" min="1">
                                                </td>
                                                <td>{{ $detalle->descripcion }}</td>
                                                <td>{{ $detalle->unidadMedida->nombre }}</td>
                                                <td>{{ $cantidadDisponible }}</td>
                                                <td>{{ $detalle->entregado }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <button class="btn btn-success" id="processButton">Procesar</button>
                            </div>
                        </div>
                        <input type="number" class="hidden" name="insumo_id" value="{{ $insumo->id }}" hidden>
                    </form>
                </div>
            </div>
        </div>
    @endforeach

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        function mostrarSuccess(mensaje) {
            Swal.fire({
                icon: 'success',
                title: mensaje,
                showConfirmButton: false,
                timer: 1500
            });
        }

        function solicitudAnulacion() {
            Swal.fire({
                title: 'Anular Ingreso',
                text: '¿Desea solicitar la autorización para anular este ingreso?',
                icon: 'danger',
                showCancelButton: true,
                confirmButtonText: 'Sí, solicitar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire(
                        'Solicitud enviada',
                        'La solicitud para anular el ingreso ha sido enviada.',
                        'success'
                    );
                }
            });
        }

        function procesarSalida(label_id) {
            // Mostrar el modal inicial
            $('#procesarSalidaModal-' + label_id).modal('show');
            let modal = document.getElementById('procesarSalidaModal-' + label_id);
        }
    </script>
@endsection
