<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrazabilidadProduccionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trazabilidad_produccion', function (Blueprint $table) {
            $table->id();
            $table->string('producto')->nullable();
            $table->string('estilo')->nullable();
            $table->text('descripcion')->nullable();
            $table->decimal('meta_curva', 8, 2)->nullable(); // Ajusta la precisión según sea necesario
            $table->integer('produccion');
            $table->decimal('smv', 8, 2)->nullable();
            $table->integer('operarios')->nullable();
            $table->decimal('minutos', 8, 2)->nullable(); // Ajusta la precisión según sea necesario
            $table->integer('meta')->nullable();
            $table->decimal('curva_porcentaje', 5, 2)->nullable(); // Ajusta la precisión según sea necesario
            $table->string('po')->nullable();
            $table->tinyInteger('estado')->default(1);
            $table->tinyInteger('tipo')->default(1);
            $table->unsignedBigInteger('linea_id');
            $table->unsignedBigInteger('encargado_id');
            $table->softDeletes(); // Campo para soft deletes
            $table->timestamps();

            // Si necesitas agregar relaciones puedes hacerlo con foreign keys
            $table->foreign('linea_id')->references('id')->on('catalogo');
            $table->foreign('encargado_id')->references('id')->on('users');
        });
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('trazabilidad_produccion');
    }
}
