<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdenCorteDetallesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orden_corte_detalles', function (Blueprint $table) {
            $table->id();
            $table->integer('rollos');
            $table->string('lote');
            $table->integer('yardas');
            $table->integer('lienzos');
            $table->integer('yardas_tendidas');
            $table->integer('puntas');
            $table->unsignedBigInteger('unidad_medida_id');
            $table->unsignedBigInteger('tipo_defecto_id');
            $table->unsignedBigInteger('orden_corte_id');
            $table->integer('puntas_utilizadas');
            $table->integer('sobrantes');
            $table->integer('faltantes');
            $table->integer('empalmes');
            $table->text('observaciones')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Definir las llaves foráneas
            $table->foreign('orden_corte_id')->references('id')->on('orden_cortes')->onDelete('cascade');
            $table->foreign('unidad_medida_id')->references('id')->on('unidad_medidas')->onDelete('cascade');
            $table->foreign('tipo_defecto_id')->references('id')->on('productos_medida')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orden_corte_detalles');
    }
}
