<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInventarioDetallesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inventarios_detalles', function (Blueprint $table) {
            $table->id();
            $table->string('descripcion')->nullable();
            $table->string('estilo')->nullable();
            $table->integer('cantidad_esperada')->nullable();
            $table->integer('cantidad_recibida')->nullable();
            $table->integer('faltante')->nullable();
            $table->integer('cajas')->nullable();
            $table->string('observaciones')->nullable();
            $table->tinyInteger('estado');
            $table->unsignedBigInteger('unidad_medida_id')->nullable();
            $table->unsignedBigInteger('talla_id')->nullable();
            $table->unsignedBigInteger('color_id')->nullable();
            $table->unsignedBigInteger('inventario_id');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('unidad_medida_id')->references('id')->on('productos_medida');
            $table->foreign('talla_id')->references('id')->on('catalogo');
            $table->foreign('color_id')->references('id')->on('catalogo');
            $table->foreign('inventario_id')->references('id')->on('inventarios');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inventarios_detalles');
    }
}
