<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProduccionTalla extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'produccion_tallas';
    protected $fillable = [
        'descripcion',
        'cantidad',
        'estado',
        'tipo',
        'talla_id',
        'linea_id',
        'producto_id',
    ];

    public function talla()
    {
        return $this->belongsTo(CatalogoCampo::class, 'talla_id');
    }

    public function linea()
    {
        return $this->belongsTo(LineaProduccion::class, 'linea_id');
    }

    public function producto()
    {
        return $this->belongsTo(Producto::class, 'producto_id');
    }
}
