<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InventarioDetalle extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'inventarios_detalles';
    protected $fillable = [
        'descripcion',
        'estilo',
        'cantidad_esperada',
        'cantidad_recibida',
        'faltante',
        'cantidad_entregada',
        'cajas',
        'observaciones',
        'estado',
        'unidad_medida_id',
        'talla_id',
        'color_id',
        'inventario_id',
        'created_at',
        'updated_at',
    ];

    public function inventario()
    {
        return $this->belongsTo(Inventario::class);
    }

    public function color()
    {
        return $this->belongsTo(CatalogoCampo::class, 'color_id');
    }

    public function talla()
    {
        return $this->belongsTo(CatalogoCampo::class, 'talla_id');
    }

    public function unidadMedida()
    {
        return $this->belongsTo(ProductoMedidas::class, 'unidad_medida_id');
    }
}
