<?php

namespace App\Http\Controllers;

use PDF;
use App\User;
use DateTime;
use App\Cliente;
use App\Facturas;
use App\Producto;
use App\Cotizacion;
use App\ProductoTipos;
use App\SalidaAlmacen;
use App\IngresoAlmacen;
use App\OrdenProduccion;
use App\ProductoMedidas;
use App\ClienteContactos;
use App\ProductoCategorias;
use Illuminate\Support\Str;
use App\CotizacionProductos;
use Illuminate\Http\Request;
use App\OrdenProduccionDetalle;
use App\OrdenProduccionParcial;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class VentasController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //Agregar clientes
        $fechaAhora = date("Y/m/d");
        $id_ejecutivo = Auth::id();
        $cotizaciones = DB::table('cotizaciones')
            ->where('validez_cotizacion', '>=', $fechaAhora)
            ->where('cotizaciones.id_usuario', $id_ejecutivo)
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', 1)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('productos_medida', 'productos.id_medida', '=', 'productos_medida.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->select(
                'cotizaciones.id',
                'cotizaciones.id_usuario',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'users.name as nombreEjecutivo',
                'productos_medida.nombre as nombreMedida',
                'clientes.nombre as nombreCliente'
            )
            ->get();
        //Cotizaciones OK ING
        $cotizaciones2 = DB::table('cotizaciones')
            ->where('validez_cotizacion', '>=', $fechaAhora)
            ->where('cotizaciones.id_usuario', $id_ejecutivo)
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', 100)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('productos_medida', 'productos.id_medida', '=', 'productos_medida.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->select(
                'cotizaciones.id',
                'cotizaciones.id_usuario',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'users.name as nombreEjecutivo',
                'productos_medida.nombre as nombreMedida',
                'clientes.nombre as nombreCliente',
                'cotizaciones_productos.comentario_ing'
            )
            ->get();
        //Cotizaciones RECHAZADAS
        $cotizaciones3 = DB::table('cotizaciones')
            ->where('validez_cotizacion', '>=', $fechaAhora)
            ->where('cotizaciones.id_usuario', $id_ejecutivo)
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', 99)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('productos_medida', 'productos.id_medida', '=', 'productos_medida.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->select(
                'cotizaciones.id',
                'cotizaciones.id_usuario',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'users.name as nombreEjecutivo',
                'productos_medida.nombre as nombreMedida',
                'clientes.nombre as nombreCliente',
                'cotizaciones_productos.comentario_ing'
            )
            ->get();
        //Cotizaciones OK
        $cotizaciones4 = DB::table('cotizaciones')
            ->where('validez_cotizacion', '>=', $fechaAhora)
            ->where('cotizaciones.id_usuario', $id_ejecutivo)
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', 200)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('productos_medida', 'productos.id_medida', '=', 'productos_medida.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->select(
                'cotizaciones.id',
                'cotizaciones.id_usuario',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'users.name as nombreEjecutivo',
                'productos_medida.nombre as nombreMedida',
                'clientes.nombre as nombreCliente',
                'cotizaciones_productos.comentario_ing'
            )
            ->get();
        //dd($cotizaciones);


        return view('ventas.dashboard', compact('cotizaciones', 'cotizaciones2', 'cotizaciones3', 'cotizaciones4'));
    }
    public function dashboardCotizacionesG()
    {
        //Agregar clientes
        $fechaAhora = date("Y/m/d");

        $cotizaciones = DB::table('cotizaciones')
            ->where('validez_cotizacion', '>=', $fechaAhora)
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', 1)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('productos_medida', 'productos.id_medida', '=', 'productos_medida.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->select(
                'cotizaciones.id',
                'cotizaciones.id_usuario',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'users.name as nombreEjecutivo',
                'id_moneda',
                'productos_medida.nombre as nombreMedida',
                'clientes.nombre as nombreCliente'
            )
            ->get();
        //Cotizaciones OK ING
        $cotizaciones2 = DB::table('cotizaciones')
            ->where('validez_cotizacion', '>=', $fechaAhora)
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', 100)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('productos_medida', 'productos.id_medida', '=', 'productos_medida.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->select(
                'cotizaciones.id',
                'cotizaciones.id_usuario',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'users.name as nombreEjecutivo',
                'id_moneda',
                'productos_medida.nombre as nombreMedida',
                'clientes.nombre as nombreCliente'
            )
            ->get();
        //Cotizaciones RECHAZADAS
        $cotizaciones3 = DB::table('cotizaciones')
            ->where('validez_cotizacion', '>=', $fechaAhora)
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', 99)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('productos_medida', 'productos.id_medida', '=', 'productos_medida.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->select(
                'cotizaciones.id',
                'cotizaciones.id_usuario',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'users.name as nombreEjecutivo',
                'id_moneda',
                'productos_medida.nombre as nombreMedida',
                'clientes.nombre as nombreCliente'
            )
            ->get();
        //Cotizaciones OK
        $cotizaciones4 = DB::table('cotizaciones')
            ->where('validez_cotizacion', '>=', $fechaAhora)
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', 200)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('productos_medida', 'productos.id_medida', '=', 'productos_medida.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->select(
                'cotizaciones.id',
                'cotizaciones.id_usuario',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'users.name as nombreEjecutivo',
                'id_moneda',
                'productos_medida.nombre as nombreMedida',
                'clientes.nombre as nombreCliente'
            )
            ->get();
        //dd($cotizaciones);
        return view('ventas.dashboard_gerencia', compact('cotizaciones', 'cotizaciones2', 'cotizaciones3', 'cotizaciones4'));
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function mesGT($mesBuscar)
    {
        if ($mesBuscar == 1) {
            $mes = 'enero';
        }
        if ($mesBuscar == 2) {
            $mes = 'febrero';
        }
        if ($mesBuscar == 3) {
            $mes = 'marzo';
        }
        if ($mesBuscar == 4) {
            $mes = 'abril';
        }
        if ($mesBuscar == 5) {
            $mes = 'mayo';
        }
        if ($mesBuscar == 6) {
            $mes = 'junio';
        }
        if ($mesBuscar == 7) {
            $mes = 'julio';
        }
        if ($mesBuscar == 8) {
            $mes = 'agosto';
        }
        if ($mesBuscar == 9) {
            $mes = 'septiembre';
        }
        if ($mesBuscar == 10) {
            $mes = 'octubre';
        }
        if ($mesBuscar == 11) {
            $mes = 'noviembre';
        }
        if ($mesBuscar == 12) {
            $mes = 'diciembre';
        }
        return $mes;
    }
    //COTIZACIONES *******************************************************
    public function nueva_cotizacion()
    {
        //Fecha +15 dias
        $date_now = date('d-m-Y');
        $date_future = strtotime('+15 day', strtotime($date_now));
        $date_future = date('d-m-Y', $date_future);
        //
        $clientes = Cliente::orderBy('nombre', 'asc')->get();
        return view('ventas.cotizacion', compact('clientes', 'date_future'));
    }
    public function editarCotizacion($idCotizacion)
    {
        //
        $cotizacion = CotizacionProductos::where('id', $idCotizacion)->with('cotizacion')->with('producto')->first();
        $clientes = Cliente::orderBy('nombre', 'asc')->get();
        $productos = Producto::orderBy('nombre', 'asc')->get();
        return view('ventas.cotizacion_editar', compact('clientes', 'productos', 'cotizacion'));
    }
    public function restablecerCotizacion($idCotizacion)
    {
        //
        $cotizacion = CotizacionProductos::where('id', $idCotizacion)->with('cotizacion')->with('producto')->first();
        $clientes = Cliente::orderBy('nombre', 'asc')->get();
        $productos = Producto::orderBy('nombre', 'asc')->get();
        return view('ventas.cotizacion_restablecer', compact('clientes', 'productos', 'cotizacion'));
    }
    public function guardar_cotizacion(Request $request)
    {
        //  
        if ($request->servicios) {
            $tipo_producto = 2;
        } elseif ($request->facturacion) {
            $tipo_producto = 1;
        } else {
            $tipo_producto = 0;
        }
        $cliente = Cliente::where('id', $request->cliente)->with('info_ejecutivo')->first();
        $correo_ejecutivo = $cliente->info_ejecutivo->email;
        $cotizacion = new Cotizacion();
        $cotizacion->id_usuario =  Auth::id();
        $cotizacion->id_cliente = $request->cliente;
        $cotizacion->oc_cliente = $request->oc_cliente;
        $cotizacion->validez_cotizacion = date("Y-m-d", strtotime($request->validez_cotizacion));
        $cotizacion->id_moneda = $request->id_moneda;
        $cotizacion->condiciones_pago = $request->condiciones_pago;
        $cotizacion->condiciones_entrega = $request->condiciones_entrega;
        $cotizacion->regimen_fiscal = $request->regimen_fiscal;
        $cotizacion->observaciones = $request->observaciones ?? '';
        $cotizacion->stock = $tipo_producto;
        $cotizacion->save();

        for ($i = 0; $i < count($request->id_p); $i++) {
            $producto = Producto::where('id', $request->id_p[$i])->first();
            $cotizacion_producto = new CotizacionProductos();
            $cotizacion_producto->id_cotizacion =  $cotizacion->id;
            $cotizacion_producto->cantidad = $request->cantidad_p[$i];
            $cotizacion_producto->id_producto = $request->id_p[$i];
            $cotizacion_producto->precio = $request->precio_p[$i];
            $cotizacion_producto->estatus = 1;
            $cotizacion_producto->save();
            //Info cotizacion
            $idCotizacion = $cotizacion_producto->id;
            $correo = 'kicas48@gmail.com';
            //$correo='erickfernando85@gmail.com';
            $referencia = $cliente->referencia;
            // Mail::send('email.envio_cotizacion_ok', compact('idCotizacion'), function ($message) use ($correo, $referencia, $idCotizacion, $correo_ejecutivo) {
            //     $message->from('info@laravelrp.com', 'Concisa');
            //     $message->to($correo);
            //     // $message->to('anylopeza3@gmail.com');
            //     $message->to($correo_ejecutivo);
            //     $message->subject('EMISIÓN COTIZACIÓN - ' . $referencia . ' - ' . $idCotizacion);
            // });
        }
        $arrResponse = [
            'message' => 'Cotización guardada correctamente'
        ];
        if (Auth::id() == 7 || Auth::id() == 12 || Auth::id() == 8) {
            return redirect()->route('ventas.dashboard_gerencia')->with($arrResponse);
        } else {
            return redirect()->route('ventas.dashboard')->with($arrResponse);
        }
    }
    public function guardar_cotizacion_restablecer(Request $request)
    {
        //  
        if ($request->servicios) {
            $tipo_producto = 2;
        } elseif ($request->facturacion) {
            $tipo_producto = 1;
        } else {
            $tipo_producto = 0;
        }
        $cliente = Cliente::where('id', $request->cliente)->with('info_ejecutivo')->first();
        $correo_ejecutivo = $cliente->info_ejecutivo->email;
        $cotizacion = new Cotizacion();
        $cotizacion->id_usuario =  Auth::id();
        $cotizacion->id_cliente = $request->cliente;
        $cotizacion->oc_cliente = $request->oc_cliente;
        $cotizacion->validez_cotizacion = date("Y-m-d", strtotime($request->validez_cotizacion));
        $cotizacion->id_moneda = $request->id_moneda;
        $cotizacion->condiciones_pago = $request->condiciones_pago;
        $cotizacion->condiciones_entrega = $request->condiciones_entrega;
        $cotizacion->regimen_fiscal = $request->regimen_fiscal;
        $cotizacion->observaciones = $request->observaciones ?? '';
        $cotizacion->stock = $tipo_producto;
        $cotizacion->save();

        $cotizacion_producto = new CotizacionProductos();
        $cotizacion_producto->id_cotizacion =  $cotizacion->id;
        $cotizacion_producto->cantidad = $request->cantidad_p;
        $cotizacion_producto->id_producto = $request->id_p;
        $cotizacion_producto->precio = $request->precio_p;
        $cotizacion_producto->estatus = 1;
        $cotizacion_producto->save();
        //Info cotizacion
        $idCotizacion = $cotizacion_producto->id;
        $correo = 'kicas48@gmail.com';
        //$correo='erickfernando85@gmail.com';
        $referencia = $cliente->referencia;

        // Mail::send('email.envio_cotizacion_ok', compact('idCotizacion'), function ($message) use ($correo, $referencia, $idCotizacion, $correo_ejecutivo) {
        //     $message->from('info@laravelrp.com', 'Concisa');
        //     $message->to($correo);
        //     $message->to('anylopeza3@gmail.com');
        //     $message->to($correo_ejecutivo);
        //     $message->subject('APROBACIÓN - ' . $referencia . ' - ' . $idCotizacion);
        // });


        $arrResponse = [
            'message' => 'Cotización guardada correctamente'
        ];
        if (Auth::id() == 7 || Auth::id() == 12 || Auth::id() == 8) {
            return redirect()->route('ventas.dashboard_gerencia')->with($arrResponse);
        } else {
            return redirect()->route('ventas.dashboard')->with($arrResponse);
        }
    }
    public function actualizarCotizacion(Request $request, $idCotizacion)
    {
        //
        $cliente = Cliente::where('id', $request->cliente)->with('info_ejecutivo')->first();
        $correo_ejecutivo = $cliente->info_ejecutivo->email;
        $cotizacion = Cotizacion::where('id', $request->id_cotizacion_padre)->first();
        $cotizacion->id_usuario =  Auth::id();
        $cotizacion->id_cliente = $request->cliente;
        $cotizacion->oc_cliente = $request->oc_cliente;
        $cotizacion->validez_cotizacion = date("Y-m-d", strtotime($request->validez_cotizacion));
        $cotizacion->id_moneda = $request->id_moneda;
        $cotizacion->condiciones_pago = $request->condiciones_pago;
        $cotizacion->condiciones_entrega = $request->condiciones_entrega;
        $cotizacion->regimen_fiscal = $request->regimen_fiscal;
        $cotizacion->observaciones = $request->observaciones ?? '';
        $cotizacion->update();

        $cotizacion_producto = CotizacionProductos::where('id', $idCotizacion)->first();
        $cotizacion_producto->id_cotizacion =  $cotizacion->id;
        $cotizacion_producto->cantidad = $request->cantidad_p;
        $cotizacion_producto->id_producto = $request->id_p;
        $cotizacion_producto->precio = $request->precio_p;
        $cotizacion_producto->estatus = 1;
        $cotizacion_producto->update();
        //Info cotizacion
        $idCotizacion = $idCotizacion;
        $correo = 'kicas48@gmail.com';
        //$correo='erickfernando85@gmail.com';
        $referencia = $cliente->referencia;
        // Mail::send('email.envio_cotizacion_ok', compact('idCotizacion'), function ($message) use ($correo, $referencia, $idCotizacion, $correo_ejecutivo) {
        //     $message->from('info@laravelrp.com', 'Concisa');
        //     $message->to($correo);
        //     $message->to('anylopeza3@gmail.com');
        //     $message->to($correo_ejecutivo);
        //     $message->subject('APROBACIÓN - ' . $referencia . ' - ' . $idCotizacion);
        // });
        $arrResponse = [
            'message' => 'Cotización actualizada correctamente'
        ];
        return redirect()->route('ventas.dashboard')->with($arrResponse);
    }
    public function okCotizacion($idCotizacion)
    {
        //$path = url('/cotizaciones').'/CO_'.$cotizacion_producto->id.'.pdf';
        //$nombreCotizacion='/cotizaciones/CO_'.$cotizacion_producto->id.'.pdf';

        $cotizacion_producto = CotizacionProductos::where('id', $idCotizacion)->with('cotizacion')->with('producto')->first();
        $ejecutivo = Cotizacion::where('id', $cotizacion_producto->id_cotizacion)->with('ejecutivo')->first();
        $mesInt = (int)date("m");
        $infoCotizacion = [
            'dia' => date("d"),
            'mes' => $mes = VentasController::mesGT($mesInt),
            'ano' => date("Y"),
            'nombre_cliente' => $cotizacion_producto->cotizacion->cliente->nombre,
            'direccion_cliente' => $cotizacion_producto->cotizacion->cliente->direccion,
            'nit_cliente' => $cotizacion_producto->cotizacion->cliente->nit,
            'telefono_cliente' => $cotizacion_producto->cotizacion->cliente->telefono,
            'id_cliente' => $cotizacion_producto->cotizacion->cliente->id,
            'id_moneda' => $cotizacion_producto->cotizacion->id_moneda == 2 ? '$' : 'Q',
            'nombre_contacto' => $cotizacion_producto->cotizacion->cliente->nombre_contacto,
            'fecha_validez' => date("d-m-Y", strtotime($cotizacion_producto->cotizacion->validez_cotizacion)),
            'cantidad' => $cotizacion_producto->cantidad,
            'precio' => $cotizacion_producto->precio,
            'tipo_regimen' => $cotizacion_producto->cotizacion->cliente->tipo_regimen,
            'nombre_producto' => $cotizacion_producto->producto->nombre,
            'medida' => $cotizacion_producto->producto->medida->nombre,
            'categoria' => $cotizacion_producto->producto->categoria->nombre,
            'total' => $cotizacion_producto->cantidad * $cotizacion_producto->precio,
            'condicion' => $cotizacion_producto->cotizacion->cliente->condiciones_pago,
            'id' => $cotizacion_producto->id,
            'estatus' => $cotizacion_producto->estatus,
            'referencia' => $cotizacion_producto->cotizacion->cliente->referencia,
            'observaciones' => $cotizacion_producto->cotizacion->observaciones ?? '',
            'nombre_ejecutivo' => $ejecutivo->ejecutivo->name,
            'firma' => url($ejecutivo->ejecutivo->imagen),
            'celular' => $ejecutivo->ejecutivo->celular,
            'stock' => $cotizacion_producto->cotizacion->stock,
        ];

        //dd($cotizacion_producto->producto->nombre);

        return view('ventas.cotizacion_ok', compact('infoCotizacion'));
    }

    public function cotizacionEnviar($idCotizacion)
    {
        $path = url('/cotizaciones') . '/CO_' . $idCotizacion . '.pdf';
        $nombreCotizacion = '/cotizaciones/CO_' . $idCotizacion . '.pdf';
        $cotizacion_producto = CotizacionProductos::where('id', $idCotizacion)->with('cotizacion')->with('producto')->first();
        $ejecutivo = Cotizacion::where('id', $cotizacion_producto->id_cotizacion)->with('ejecutivo')->first();
        $mesInt = (int)date("m");
        $infoCotizacion = [
            'dia' => date("d"),
            'mes' => $mes = VentasController::mesGT($mesInt),
            'ano' => date("Y"),
            'nombre_cliente' => $cotizacion_producto->cotizacion->cliente->nombre,
            'direccion_cliente' => $cotizacion_producto->cotizacion->cliente->direccion,
            'nit_cliente' => $cotizacion_producto->cotizacion->cliente->nit,
            'telefono_cliente' => $cotizacion_producto->cotizacion->cliente->telefono,
            'id_moneda' => $cotizacion_producto->cotizacion->id_moneda == 2 ? '$' : 'Q',
            'nombre_contacto' => $cotizacion_producto->cotizacion->cliente->nombre_contacto,
            'tipo_regimen' => $cotizacion_producto->cotizacion->cliente->tipo_regimen,
            'fecha_validez' => date("d-m-Y", strtotime($cotizacion_producto->cotizacion->validez_cotizacion)),
            'cantidad' => $cotizacion_producto->cantidad,
            'precio' => $cotizacion_producto->precio,
            'nombre_producto' => $cotizacion_producto->producto->nombre,
            'medida' => $cotizacion_producto->producto->medida->nombre,
            'categoria' => $cotizacion_producto->producto->categoria->nombre,
            'total' => $cotizacion_producto->cantidad * $cotizacion_producto->precio,
            'condicion' => $cotizacion_producto->cotizacion->cliente->condiciones_pago,
            'id' => $cotizacion_producto->id,
            'referencia' => $cotizacion_producto->cotizacion->cliente->referencia,
            'observaciones' => $cotizacion_producto->cotizacion->observaciones ?? '',
            'nombre_ejecutivo' => $ejecutivo->ejecutivo->name,
            'firma' => url($ejecutivo->ejecutivo->imagen),
            'celular' => $ejecutivo->ejecutivo->celular,
        ];


        $cliente = Cliente::where('id', $cotizacion_producto->cotizacion->id_cliente)->first();

        PDF::loadView('ventas.pdf.cotizacion', compact('infoCotizacion'))->save(public_path() . $nombreCotizacion);
        $info = [
            'nombre_contacto' => $cliente->nombre_contacto,
            'id' => $cotizacion_producto->id,
        ];
        sleep(1);

        $correoU = Auth::user()->email;
        $productos = Producto::orderBy('nombre', 'asc')->get();
        $idCO = $cotizacion_producto->id;
        $correo = $cliente->correo_electronico ?? $correoU;
        $path = url('/cotizaciones') . '/CO_' . $idCotizacion . '.pdf';
        $referencia = $cliente->referencia;
        $info = [
            'nombre_contacto' => $cliente->nombre_contacto,
            'id' => $idCotizacion,
        ];

        $arrResponse = [
            'message' => 'Cotización enviada correctamente al cliente'
        ];
        $cotizacion_producto->estatus = 200;
        $cotizacion_producto->update();
        $arrResponse = [
            'message' => 'Cotización enviada'
        ];
        return redirect()->route('ventas.dashboard')->with($arrResponse);
    }
    public function okCotizacion2(Request $request)
    {
        if ($request->accion == "aprobado") {
            $idCotizacion = $request->idCotizacion;
            $comentario = $request->observaciones;
            $cotizacion_producto = CotizacionProductos::where('id', $idCotizacion)->first();

            $ejecutivo = Cotizacion::where('id', $cotizacion_producto->id_cotizacion)->with('ejecutivo')->with('cliente')->first();
            $correo_ejecutivo = $ejecutivo->cliente->info_ejecutivo->email;
            $referencia2 = $cotizacion_producto->cotizacion->cliente->referencia;
            $idCO2 = $cotizacion_producto->id;

            // Mail::send('email.envio_cotizacion_ok2', compact('cotizacion_producto', 'comentario'), function ($message) use ($referencia2, $idCO2, $correo_ejecutivo) {
            //     $message->from('info@laravelrp.com', 'Concisa');
            //     $message->to($correo_ejecutivo);
            //     $message->subject('Cotización Aprobada ' . $idCO2 . ' - ' . $referencia2);
            // });

            $cotizacion_producto->estatus = 100;
            $cotizacion_producto->comentario_ing = $comentario;
            $cotizacion_producto->update();
            $arrResponse = [
                'message' => 'Cotización aprobada'
            ];
            return redirect()->route('ventas.dashboard_gerencia')->with($arrResponse);
        } else {
            $cotizacion_producto = CotizacionProductos::where('id', $request->idCotizacion)->with('cotizacion')->with('producto')->first();
            $correo_ejecutivo = $cotizacion_producto->cotizacion->cliente->info_ejecutivo->email;
            $referencia = $cotizacion_producto->cotizacion->cliente->referencia;
            $info = [
                'id_cotizacion' => $cotizacion_producto->id,
                'nombre_cliente' => $cotizacion_producto->cotizacion->cliente->nombre,
                'referencia_cliente' => $cotizacion_producto->cotizacion->cliente->referencia,
                'producto' => $cotizacion_producto->producto->nombre
            ];
            $cotizacion_producto->estatus = 99;
            $cotizacion_producto->comentario_ing = $request->observaciones ?? '';
            $cotizacion_producto->update();
            $arrResponse = [
                'message' => 'Cotización rechazada'
            ];
            $id_cotizacion = $cotizacion_producto->id;
            // Mail::send('email.envio_cotizacion_rechazada', compact('info', 'cotizacion_producto'), function ($message) use ($correo_ejecutivo, $referencia, $id_cotizacion) {
            //     $message->from('info@laravelrp.com', 'Cotización Rechazada #' . $id_cotizacion . '  - ' . $referencia);
            //     $message->to('kicas48@gmail.com');
            //     $message->to('anylopeza3@gmail.com');
            //     $message->to($correo_ejecutivo);
            //     $message->subject('Cotización Rechazada #' . $id_cotizacion . ' - ' . $referencia);
            // });
            return redirect()->route('ventas.dashboard_gerencia')->with($arrResponse);
        }
    }
    public function okCotizacion3(Request $request)
    {
    }

    public function archivar_cotizacion(Request $request)
    {
        //
        $cotizacion_producto = CotizacionProductos::where('id', $request->idCotizacionProducto)->first();
        $cotizacion_producto->estatus = 4;
        $cotizacion_producto->update();
        return response($cotizacion_producto);
    }
    public function anular_cotizacion(Request $request)
    {
        //
        $cotizacion_producto = CotizacionProductos::where('id', $request->idCotizacionProducto)->first();
        $cotizacion_producto->estatus = 99;
        $cotizacion_producto->update();
        return response($cotizacion_producto);
    }
    public function anularOP(Request $request)
    {
        //
        $op = OrdenProduccion::where('id', $request->idOP)->first();
        $op->status = 99;
        $op->update();
        return response($op);
    }
    public function anularOPG(OrdenProduccion $idOrden)
    {
        //
        //dd($idOrden);
        $idOrden->status = 99;
        $idOrden->update();
        $arrResponse = [
            'message' => 'Orden de producción anulada'
        ];
        return redirect()->route('ventas.dashboard_produccion_gerencia')->with($arrResponse);
    }
    public function cotizacion_produccion(Request $request)
    {
        //
        $cotizacion_producto = CotizacionProductos::where('id', $request->idCotizacionProducto)->with('producto')->with('cotizacion')->first();
        if ($cotizacion_producto->cotizacion->stock == 1) {
            $cotizacion_producto->estatus = 5;
            $cotizacion_producto->update();
            $arrResponse = [
                'message' => 'Cotización aprobada para inventario'
            ];

            $ejecutivo = Cotizacion::where('id', $cotizacion_producto->id_cotizacion)->with('ejecutivo')->first();
            $mesInt = (int)date("m");


            $op = new IngresoAlmacen();
            $op->id_usuario =  Auth::id();
            $op->id_cliente = $cotizacion_producto->cotizacion->id_cliente;
            $op->id_producto = $cotizacion_producto->id_producto;
            $op->cantidad = $cotizacion_producto->cantidad;
            $op->id_op = 9999999;
            $op->id_op_parcial = 0;
            $op->observaciones = $request->observaciones ?? '';
            $op->status = 1;
            $op->id_cotizacion_producto = $cotizacion_producto->id;
            $op->save();

            return response($cotizacion_producto->cotizacion->stock);
        }

        if ($cotizacion_producto->cotizacion->stock == 2) {
            $cotizacion_producto->estatus = 4;
            $cotizacion_producto->update();
            $idCotizacion = $cotizacion_producto->id;
            $referencia = $cotizacion_producto->cotizacion->cliente->referencia;
            $x = new SalidaAlmacen();
            $x->id_usuario =  Auth::id();
            $x->id_cotizacion = $cotizacion_producto->id;
            $x->cantidad = $cotizacion_producto->cantidad;
            $x->id_producto = $cotizacion_producto->id_producto;
            $x->id_cliente = $cotizacion_producto->cotizacion->id_cliente;
            $x->estatus = 6;
            $x->id_op = 0;
            $x->observaciones = $request->observaciones ?? '';
            $x->save();


            $cliente = Cliente::where('id', $cotizacion_producto->cotizacion->id_cliente)->first();


            $productos = Producto::orderBy('nombre', 'asc')->get();
            $idCO = $cotizacion_producto->id;
            $path = url('/cotizaciones') . '/CO_' . $idCotizacion . '.pdf';
            $referencia = $cliente->referencia;
            $info = [
                'nombre_contacto' => $cliente->nombre_contacto,
                'id' => $idCotizacion,
            ];

            $id_salida = $x->id;
            $info = [
                'idSalida' => $id_salida,
                'idCotizacion' => $x->id_cotizacion,
                'nombreCliente' => $cliente->referencia
            ];

            // Mail::send('email.envio_pendiente_factura', compact('info'), function ($message) use ($id_salida, $referencia) {
            //     $message->from('info@laravelrp.com', 'Pendiente Facturar Cotización No. ' . $id_salida . ' - ' . $referencia);
            //     $message->to('anylopeza3@gmail.com');
            //     $message->to('esmeralda@concisa.com.gt');

            //     $message->subject('Pendiente Facturar - ' . $id_salida . ' - ' . $referencia);
            // });
            $arrResponse = [
                'message' => 'Cotización enviada a Facturar'
            ];

            return response($cotizacion_producto->cotizacion->stock);
        }
        $cotizacion_producto->estatus = 3;
        $cotizacion_producto->update();

        $cotizacion = Cotizacion::where('id', $cotizacion_producto->id_cotizacion)->first();

        $cantidad_p = $cotizacion_producto->cantidad;
        $kgs_millar = $cotizacion_producto->producto->factor_conversion_kilos;
        $kgs_procesar = $cantidad_p * $kgs_millar;
        $op = new OrdenProduccion();
        $op->id_usuario =  Auth::id();
        $op->id_cliente = $cotizacion->id_cliente;
        $op->id_producto = $cotizacion_producto->id_producto;
        $op->cantidad = $cantidad_p;
        $op->lista_materiales = '';
        $op->condiciones_entrega = $cotizacion->condiciones_entrega;
        //$op->fecha_prevista = date("Y-m-d", strtotime($request->fecha_prevista));
        $op->id_cotizacion = $cotizacion->id;
        $op->id_cotizacion_producto = $cotizacion_producto->id;
        $op->kgs_millar = $kgs_millar; //----
        $op->kgs_procesar = $kgs_procesar; //----
        $op->numero_oc = ''; //----
        $op->micras = $cotizacion_producto->producto->micras; //----
        $op->caracteristicas = $cotizacion_producto->producto->tipos;
        $op->observaciones = $cotizacion->observaciones;
        $op->comentario_ing = '';
        $op->status = 1;
        $op->inventario = 0;
        $op->save();

        $idOP = $op->id;
        // Mail::send('email.solicitud_autorizacion', compact('op'), function ($message) use ($idOP) {
        //     $message->from('info@laravelrp.com', 'Concisa OP ' . $idOP);
        //     $message->to('kicas48@gmail.com');
        //     // $message->to('anylopeza3@gmail.com');
        //     //$message->to('erickfernando85@gmail.com');
        //     $message->subject('OP para aprobación - OP' . $idOP);
        // });
        return response($cotizacion_producto);
    }
    public function cotizacion_archivadas()
    {
        //
        $fechaAhora = date("Y/m/d");
        $cotizacionesArchivadasOriginal = DB::table('cotizaciones')
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', 4)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->select(
                'cotizaciones.id',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'clientes.nombre as nombreCliente',
                'comentario_facturacion',
                'cotizaciones.observaciones'
            )
            ->get();
        $cotizacionesArchivadasStock = DB::table('cotizaciones')->where('stock', 1)
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', '<>', 4)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->select(
                'cotizaciones.id',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'clientes.nombre as nombreCliente',
                'stock',
                'comentario_facturacion',
                'cotizaciones.observaciones'
            )
            ->get();
        $cotizacionesVencidas = DB::table('cotizaciones')
            ->where('validez_cotizacion', '<', $fechaAhora)
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', 1)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->select(
                'cotizaciones.id',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'clientes.nombre as nombreCliente',
                'comentario_facturacion',
                'cotizaciones.observaciones'
            )
            ->get();
        $cotizacionesAnuladas = DB::table('cotizaciones')
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', 99)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->select(
                'cotizaciones.id',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'clientes.nombre as nombreCliente',
                'comentario_facturacion',
                'cotizaciones.observaciones'
            )
            ->get();
        $cotizacionesAnuladas2 = DB::table('cotizaciones')
            ->join('cotizaciones_productos', 'cotizaciones.id', '=', 'cotizaciones_productos.id_cotizacion')
            ->where('estatus', 9)
            ->join('productos', 'cotizaciones_productos.id_producto', '=', 'productos.id')
            ->join('clientes', 'cotizaciones.id_cliente', '=', 'clientes.id')
            ->select(
                'cotizaciones_productos.id',
                'cotizaciones.validez_cotizacion',
                'cotizaciones.created_at',
                'cotizaciones_productos.cantidad',
                'cotizaciones_productos.precio',
                'cotizaciones_productos.id as idCotizacionProducto',
                'productos.nombre as nombreProducto',
                'clientes.nombre as nombreCliente',
                'comentario_facturacion',
                'cotizaciones.observaciones'
            )
            ->get();

        $cotizacionesArchivadas = $cotizacionesArchivadasOriginal->concat($cotizacionesArchivadasStock);
        // var_dump($cotizacionesArchivadas);
        return view('ventas.cotizaciones_archivadas', compact('cotizacionesVencidas', 'cotizacionesArchivadas', 'cotizacionesAnuladas', 'cotizacionesAnuladas2'));
    }
    public function actualizarComentarioCotizacion(Request $request)
    {
        $cotizacion = CotizacionProductos::where('id', $request->id_cotizacion)->first();
        $cotizacion->comentario_facturacion = $request->mensaje;
        $cotizacion->update();
        return response($cotizacion);
    }
    public function buscarProducto(Request $request)
    {
        $query = strtoupper($request->term);
        if ($request->inventario == 'true') {
            $data = [];
            $inventario = IngresoAlmacen::where('status', 1)
                ->where('id_cliente', 999999)
                ->with('producto')
                ->selectRaw('*,sum(cantidad) as total')
                ->groupBy('id_producto')
                ->get();

            foreach ($inventario as $i) {

                $frase = strtoupper($i->producto->nombre);
                $termino = strpos($frase, $query);
                if ($termino !== false) {
                    if ($i->total > 0) {
                        $data[] = [
                            'label' => $i->producto->nombre,
                            'id' => $i->producto->id,
                            'precio' => $i->producto->precio_venta,
                            'unidad' => $i->producto->medida->nombre,
                            'factor_conversion_kilos' => $i->producto->factor_conversion_kilos,
                            'micras' => $i->producto->micras,
                            'caracteristicas' => $i->producto->tipos,
                            'id_unidad' => $i->producto->medida->id,
                            'cantidad' => $i->total
                        ];
                    }
                }
            }
            return response()->json($data);
        } elseif ($request->servicios == 'true') {
            $results = Producto::where("id_tipo", 5)->where("nombre", "LIKE", "%" . $query . "%")->with('medida')->get();

            $data = [];

            foreach ($results as $result) {
                $data[] = [
                    'label' => $result->nombre,
                    'id' => $result->id,
                    'precio' => $result->precio_venta,
                    'unidad' => $result->medida->nombre,
                    'factor_conversion_kilos' => $result->factor_conversion_kilos,
                    'micras' => $result->micras,
                    'caracteristicas' => $result->tipos,
                    'id_unidad' => $result->medida->id
                ];
            }
            return response()->json($data);
        } else {
            $results = Producto::where("id_tipo", 3)->where("deshabilitar", 0)->where("nombre", "LIKE", "%" . $query . "%")->with('medida')->get();

            $data = [];

            foreach ($results as $result) {
                $data[] = [
                    'label' => $result->nombre,
                    'id' => $result->id,
                    'precio' => $result->precio_venta,
                    'unidad' => $result->medida->nombre,
                    'factor_conversion_kilos' => $result->factor_conversion_kilos,
                    'micras' => $result->micras,
                    'caracteristicas' => $result->tipos,
                    'id_unidad' => $result->medida->id
                ];
            }
            return response()->json($data);
        }
    }
    public function buscarProductoPrima(Request $request)
    {
        $query = strtoupper($request->term);
        $results = Producto::where("nombre", "LIKE", "%" . $query . "%")
            ->Where("id_tipo", 2)
            ->with('medida')
            ->orderBy('nombre', 'ASC')
            ->get();

        $data = [];
        foreach ($results as $result) {
            $data[] = [
                'label' => $result->nombre,
                'id' => $result->id,
                'precio' => $result->precio_venta,
                'unidad' => $result->medida->nombre,
                'factor_conversion_kilos' => $result->factor_conversion_kilos,
                'micras' => $result->micras,
                'caracteristicas' => $result->tipos,
                'id_unidad' => $result->medida->id
            ];
        }
        $results = Producto::where("nombre", "LIKE", "%" . $query . "%")
            ->Where("id_tipo", 4)
            ->with('medida')
            ->orderBy('nombre', 'ASC')
            ->get();
        foreach ($results as $result) {
            $data[] = [
                'label' => $result->nombre,
                'id' => $result->id,
                'precio' => $result->precio_venta,
                'unidad' => $result->medida->nombre,
                'factor_conversion_kilos' => $result->factor_conversion_kilos,
                'micras' => $result->micras,
                'caracteristicas' => $result->tipos,
                'id_unidad' => $result->medida->id
            ];
        }
        $results = Producto::where("nombre", "LIKE", "%" . $query . "%")
            ->Where("id_tipo", 3)
            ->with('medida')
            ->orderBy('nombre', 'ASC')
            ->get();
        foreach ($results as $result) {
            $data[] = [
                'label' => $result->nombre,
                'id' => $result->id,
                'precio' => $result->precio_venta,
                'unidad' => $result->medida->nombre,
                'factor_conversion_kilos' => $result->factor_conversion_kilos,
                'micras' => $result->micras,
                'caracteristicas' => $result->tipos,
                'id_unidad' => $result->medida->id
            ];
        }
        return response()->json($data);
    }

    public function dashboardPedidos()
    {
        //
        return view('ventas.dashboard_pedidos');
    }
    public function pedidoVenta()
    {
        //
        return view('ventas.pedido_venta');
    }
    public function dashboardFacturar()
    {
        //
        $salidasAlmacen = IngresoAlmacen::where('status', 2)->with('cliente')->with('producto')->get();
        return view('ventas.dashboard_facturar', compact('salidasAlmacen'));
    }
    public function pedidoFacturar()
    {
        //
        return view('ventas.pedido_facturar');
    }



    //PRODUCTOS *******************************************************
    public function dashboardProducto()
    {
        //
        $productos = Producto::orderBy('nombre', 'asc')->with('medida')->with('tipo')->with('categoria')->get();
        return view('ventas.dashboard_producto', compact('productos'));
    }
    public function producto()
    {
        //
        $medidas = ProductoMedidas::all();
        $tipos = ProductoTipos::all();
        $categorias = ProductoCategorias::all();
        return view('ventas.producto', compact('medidas', 'tipos', 'categorias'));
    }
    public function guardar_producto(Request $request)
    {
        //
        $producto = new Producto();
        $producto->id_usuario =  Auth::id();
        $producto->nombre = $request->nombre;
        $producto->id_tipo = $request->tipo_producto;
        $producto->id_categoria = $request->categoria_producto ?? 0;
        $producto->codigo_barras = $request->codigo_barras ?? 0;
        $producto->factor_conversion_cajas = $request->factor_conversion_cajas ?? 0;
        $producto->factor_conversion_bobina = $request->factor_conversion_bobina ?? 0;
        $producto->factor_conversion_kilos = $request->factor_conversion_kilos ?? 0;
        $producto->producto_terminado = $request->producto_terminado ?? 0;
        $producto->precio_unitario = $request->precio_unitario ?? 0;
        $producto->precio_venta = $request->precio_venta ?? 0;
        $producto->equipo_venta = $request->equipo_venta ?? 0;
        $producto->costo = $request->costo ?? 0;
        $producto->id_medida = $request->unidad_medida ?? 0;
        $producto->peso_kg = $request->peso_kg ?? 0;
        $producto->materia_prima = $request->materia_prima ?? 0;
        $producto->peso_kg = $request->peso_kg ?? 0;
        $producto->micras = $request->micras ?? 0;
        $producto->tipos = $request->tipos ?? 0;
        $producto->save();
        $arrResponse = [
            'message' => 'Producto guardado correctamente'
        ];
        return redirect()->route('ventas.dashboard_producto')->with($arrResponse);
    }
    public function buscar_producto(Request $request)
    {
        //
        $producto = Producto::where('id', $request->id_producto)->with('medida')->first();
        return response($producto);
    }
    public function editarProducto($idProducto)
    {
        //
        $producto = Producto::where('id', $idProducto)->first();
        $medidas = ProductoMedidas::all();
        $tipos = ProductoTipos::all();
        $categorias = ProductoCategorias::all();
        return view('ventas.producto_editar', compact('producto', 'medidas', 'tipos', 'categorias'));
    }
    public function actualizarProducto(Request $request, Producto $producto)
    {
        //
        $producto->id_usuario =  Auth::id();
        $producto->nombre = $request->nombre;
        $producto->id_tipo = $request->tipo_producto;
        $producto->id_categoria = $request->categoria_producto ?? 0;
        $producto->codigo_barras = $request->codigo_barras ?? 0;
        $producto->factor_conversion_cajas = $request->factor_conversion_cajas ?? 0;
        $producto->factor_conversion_bobina = $request->factor_conversion_bobina ?? 0;
        $producto->factor_conversion_kilos = $request->factor_conversion_kilos ?? 0;
        $producto->producto_terminado = $request->producto_terminado ?? 0;
        $producto->precio_unitario = $request->precio_unitario ?? 0;
        $producto->precio_venta = $request->precio_venta ?? 0;
        $producto->equipo_venta = $request->equipo_venta ?? 0;
        $producto->costo = $request->costo ?? 0;
        $producto->id_medida = $request->unidad_medida ?? 0;
        $producto->peso_kg = $request->peso_kg ?? 0;
        $producto->deshabilitar = $request->deshabilitar ?? 0;
        $producto->materia_prima = $request->materia_prima ?? 0;
        $producto->producto_proceso = $request->producto_proceso ?? 0;
        $producto->micras = $request->micras ?? 0;
        $producto->tipos = $request->tipos ?? 0;
        $producto->update();
        $arrResponse = [
            'message' => 'Producto actualizado correctamente'
        ];
        return redirect()->route('ventas.dashboard_producto')->with($arrResponse);
    }

    public function eliminarProducto($id)
    {
        //
        Producto::destroy($id);
        $arrResponse = [
            'message' => 'Producto eliminado correctamente'
        ];
        return redirect()->route('ventas.dashboard_producto')->with($arrResponse);
    }

    public function productoTipos()
    {
        //
        $tipos = ProductoTipos::all();
        return view('ventas.producto_tipo', compact('tipos'));
    }
    public function productoTiposNuevo()
    {
        //
        $tipos = ProductoTipos::all();
        return view('ventas.producto_tipo_nuevo', compact('tipos'));
    }
    public function productoTiposGuardar(Request $request)
    {
        //
        $tipo = new ProductoTipos();
        $tipo->nombre =  $request->nombre;
        $tipo->save();
        $arrResponse = [
            'message' => 'Tipo guardado correctamente'
        ];
        return redirect()->route('ventas.productos_tipos')->with($arrResponse);
    }
    public function productoTiposEliminar($id)
    {
        //
        ProductoTipos::destroy($id);
        $arrResponse = [
            'message' => 'Tipo eliminado correctamente'
        ];
        return redirect()->route('ventas.productos_tipos')->with($arrResponse);
    }

    public function productoCategorias()
    {
        //
        $categorias = ProductoCategorias::all();
        return view('ventas.producto_categorias', compact('categorias'));
    }
    public function productoCategoriasNuevo()
    {
        //
        $tipos = ProductoCategorias::all();
        return view('ventas.producto_categorias_nuevo', compact('tipos'));
    }
    public function productoCategoriasGuardar(Request $request)
    {
        //
        $tipo = new ProductoCategorias();
        $tipo->nombre =  $request->nombre;
        $tipo->save();
        $arrResponse = [
            'message' => 'Categorías guardada correctamente'
        ];
        return redirect()->route('ventas.productos_categorias')->with($arrResponse);
    }
    public function productoCategoriasEliminar($id)
    {
        //
        ProductoCategorias::destroy($id);
        $arrResponse = [
            'message' => 'Categoría eliminado correctamente'
        ];
        return redirect()->route('ventas.productos_categorias')->with($arrResponse);
    }


    public function productoMedidas()
    {
        //
        $medidas = ProductoMedidas::all();
        return view('ventas.producto_medidas', compact('medidas'));
    }
    public function productoMedidasNuevo()
    {
        //
        $tipos = ProductoMedidas::all();
        return view('ventas.producto_medidas_nuevo', compact('tipos'));
    }
    public function productoMedidasGuardar(Request $request)
    {
        //
        $medidas = new ProductoMedidas();
        $medidas->nombre =  $request->nombre;
        $medidas->save();
        $arrResponse = [
            'message' => 'Unidad de medida guardada correctamente'
        ];
        return redirect()->route('ventas.productos_medidas')->with($arrResponse);
    }
    public function productoMedidasEliminar($id)
    {
        //
        ProductoMedidas::destroy($id);
        $arrResponse = [
            'message' => 'Unidad de medida eliminado correctamente'
        ];
        return redirect()->route('ventas.productos_medidas')->with($arrResponse);
    }


    //CLIENTES *******************************************************
    public function dashboardClientes()
    {
        //

        /*
        $direcciones[]='Guatemala, Ciudad'; 
        
        $i=1;
        foreach($direcciones as $direccion){
            $cliente=Cliente::where('id',$i)->first();
            $cliente->direccion=$direccion;
            $cliente->update();
            $i++;
        }*/

        $clientes = Cliente::orderBy('nombre', 'asc')->get();

        //return $pdf->stream(); //Ver el pdf
        return view('ventas.dashboard_clientes', compact('clientes'));
    }
    public function cliente()
    {
        //
        $ejecutivos = User::where('role', 2)->get();
        //dd($ejecutivos);
        return view('ventas.cliente', compact('ejecutivos'));
    }
    public function guardar_cliente(Request $request)
    {
        //        
        $cliente = new Cliente();
        $cliente->id_usuario =  Auth::id();
        $cliente->nombre = $request->nombre;
        $cliente->nit = $request->nit;
        $cliente->direccion = $request->direccion;
        $cliente->correo_electronico = $request->correo_electronico;
        $cliente->sitio_web = $request->sitio_web;
        $cliente->puesto = $request->puesto;
        $cliente->nombre_contacto = $request->nombre_contacto1;
        $cliente->telefono = $request->telefono;
        $cliente->celular = $request->celular;
        $cliente->ejecutivo = $request->ejecutivo;
        $cliente->tipo_regimen = $request->regimen_fiscal;
        $cliente->condiciones_pago = $request->condiciones_pago;
        $cliente->referencia = $request->referencia;
        $cliente->save();
        for ($i = 0; $i <= 1; $i++) {
            if ($request->nombre_contacto[$i]) {
                $nuevoContacto = new ClienteContactos();
                $nuevoContacto->id_cliente = $cliente->id;
                $nuevoContacto->nombre_contacto = $request->nombre_contacto[$i];
                $nuevoContacto->celular = $request->celular_contacto[$i];
                $nuevoContacto->correo_electronico = $request->correo_electronico_contacto[$i];
                $nuevoContacto->puesto = $request->puesto__contacto[$i];
                $nuevoContacto->save();
            }
        }
        $arrResponse = [
            'message' => 'Cliente actualizado correctamente'
        ];
        return redirect()->route('ventas.dashboard_clientes')->with($arrResponse);
    }
    public function buscar_cliente(Request $request)
    {
        //
        $clientes = Cliente::where('id', $request->id_cliente)->first();
        if ($clientes->condiciones_pago == 1) {
            $credito = 1;
        };
        if ($clientes->condiciones_pago == 6) {
            $credito = 8;
        };
        if ($clientes->condiciones_pago == 2) {
            $credito = 15;
        };
        if ($clientes->condiciones_pago == 3) {
            $credito = 30;
        };
        if ($clientes->condiciones_pago == 4) {
            $credito = 45;
        };
        if ($clientes->condiciones_pago == 5) {
            $credito = 60;
        };
        // $facturas = Facturas::where('id_cliente', $request->id_cliente)->where('estatus', 1)->get();
        // $url = route('contabilidad.ver_cuenta_corriente_info', $clientes->id);
        // $moroso = 0;
        // foreach ($facturas as $factura) {
        //     $fecha = new DateTime(date("Y-m-d"));
        //     $fechaFinal = $fecha->diff($factura->created_at)->days;

        //     if ($fechaFinal > $credito) {
        //         if ($moroso <= $fechaFinal) {
        //             $moroso = $fechaFinal - $credito;
        //         }
        //     }
        // }
        //Codigo nuevo para calculo de mora
        $facturaMora = Facturas::where('id_cliente', $request->id_cliente)->where('estatus', 1)->orderBy('created_at', 'asc')->first();
        $url = route('contabilidad.ver_cuenta_corriente_info', $clientes->id);
        $moroso = 0;
        $fecha = new DateTime(date("Y-m-d"));
        $fechaFinal = $fecha->diff($facturaMora->created_at ?? $fecha)->days;

        if ($fechaFinal > $credito) {
            $moroso = $fechaFinal - $credito;
        }
        //Fin de codigo nuevo
        $clientes->mora = $moroso;
        $clientes->url = $url;
        return response($clientes);
    }
    public function editarCliente($idCliente)
    {
        //
        $ejecutivos = User::where('role', 2)->get();
        $cliente = Cliente::where('id', $idCliente)->with('contactos')->first();
        return view('ventas.cliente_editar', compact('cliente', 'ejecutivos'));
    }
    public function actualizarCliente(Request $request, Cliente $cliente)
    {
        //
        $cliente->id_usuario =  Auth::id();
        $cliente->nombre = $request->nombre;
        $cliente->nit = $request->nit;
        $cliente->direccion = $request->direccion;
        $cliente->correo_electronico = $request->correo_electronico;
        $cliente->sitio_web = $request->sitio_web;
        $cliente->puesto = $request->puesto;
        $cliente->nombre_contacto = $request->nombre_contacto1;
        $cliente->telefono = $request->telefono;
        $cliente->celular = $request->celular;
        $cliente->tipo_regimen = $request->regimen_fiscal;
        $cliente->condiciones_pago = $request->condiciones_pago;
        $cliente->ejecutivo = $request->ejecutivo ?? 0;
        $cliente->referencia = $request->referencia;
        $cliente->update();
        ClienteContactos::where('id_cliente', $cliente->id)->delete();
        for ($i = 0; $i <= 1; $i++) {
            if ($request->nombre_contacto[$i]) {
                $nuevoContacto = new ClienteContactos();
                $nuevoContacto->id_cliente = $cliente->id;
                $nuevoContacto->nombre_contacto = $request->nombre_contacto[$i];
                $nuevoContacto->celular = $request->celular_contacto[$i];
                $nuevoContacto->correo_electronico = $request->correo_electronico_contacto[$i];
                $nuevoContacto->puesto = $request->puesto__contacto[$i];
                $nuevoContacto->save();
            }
        }
        $arrResponse = [
            'message' => 'Cliente guardado correctamente'
        ];
        return redirect()->route('ventas.dashboard_clientes')->with($arrResponse);
    }

    public function eliminarCliente($id)
    {
        //
        Cliente::destroy($id);
        ClienteContactos::where('id_cliente', $id)->delete();
        $arrResponse = [
            'message' => 'Cliente eliminado correctamente'
        ];
        return redirect()->route('ventas.dashboard_clientes')->with($arrResponse);
    }

    public function cotizacionPdf()
    {
        //
        return view('ventas.pdf.cotizacion');
    }



    public function dashboardOrdenProduccion()
    {
        //
        $fechaAhora = date("Y/m/d");
        $ops = OrdenProduccion::where('status', '>=', 1)->with('cliente')->with('producto')->get();
        //dd($cotizaciones);
        return view('ventas.dashboard_orden_produccion', compact('ops'));
    }
    public function dashboardOrdenProduccionGerencia()
    {
        //
        $fechaAhora = date("Y/m/d");
        $ops = OrdenProduccion::where('status', '>=', 2)->where('status', '!=', 99)->with('cliente')->with('producto')->get();
        $opsPendientesOk = OrdenProduccion::where('status', 1)->with('cliente')->with('producto')->get();
        //dd($opsPendientesOk);
        return view('ventas.dashboard_orden_produccion_gerencia', compact('ops', 'opsPendientesOk'));
    }
    public function nuevaOP()
    {
        //
        $clientes = Cliente::orderBy('nombre', 'asc')->get();
        return view('ventas.orden_produccion_nueva', compact('clientes'));
    }
    public function ordenProduccion($idCotizacionProducto)
    {
        //
        $cotizacion_producto = CotizacionProductos::where('id', $idCotizacionProducto)->with('producto')->first();
        $cotizacion = Cotizacion::where('id', $cotizacion_producto->id_cotizacion)->with('cliente')->first();
        return view('ventas.orden_produccion', compact('cotizacion', 'cotizacion_producto', 'idCotizacionProducto'));
    }
    public function guardarOP(Request $request)
    {
        //        
        $op = new OrdenProduccion();
        $op->id_usuario =  Auth::id();
        $op->id_cliente = $request->id_cliente;
        $op->id_producto = $request->id_producto;
        $op->cantidad = $request->cantidad;
        $op->lista_materiales = $request->lista_materiales;
        $op->condiciones_entrega = $request->condiciones_entrega;
        //$op->fecha_prevista = date("Y-m-d", strtotime($request->fecha_prevista));
        $op->id_cotizacion = $request->id_cotizacion;
        $op->id_cotizacion_producto = $request->id_cotizacion_producto;
        $op->kgs_millar = $request->kgs_millar;
        $op->kgs_procesar = $request->kgs_procesar;
        $op->numero_oc = $request->numero_oc;
        $op->micras = $request->micras;
        $op->caracteristicas = $request->caracteristicas;
        $op->observaciones = $request->observaciones;
        $op->comentario_ing = $request->comentario_ing ?? '';
        $op->status = 1;
        $op->inventario = $request->inventario;
        $op->save();
        if ($request->id_cotizacion != 999999) {
            $cotizacion_producto = CotizacionProductos::where('id', $request->id_cotizacion_producto)->first();
            $cotizacion_producto->estatus = 3;
            $cotizacion_producto->update();
        }

        $arrResponse = [
            'message' => 'Se envió OP para aprobación'
        ];
        $idOP = $op->id;
        // Mail::send('email.solicitud_autorizacion', compact('op'), function ($message) use ($idOP) {
        //     $message->from('info@laravelrp.com', 'Concisa OP ' . $idOP);
        //     $message->to('kicas48@gmail.com');
        //     // $message->to('anylopeza3@gmail.com');
        //     //$message->to('erickfernando85@gmail.com');

        //     $message->subject('OP para aprobación - OP' . $idOP);
        // });
        return redirect()->route('fabricacion.dashboard')->with($arrResponse);
    }

    public function aprobarOP($idOrden)
    {
        //        
        $op = OrdenProduccion::where('id', $idOrden)->with('cliente')->with('producto')->first();
        return view('ventas.orden_produccion_ok', compact('op'));
    }

    public function actualizarOkOP(Request $request, OrdenProduccion $op)
    {
        //
        $op->id_usuario =  Auth::id();
        $op->id_cliente = $request->id_cliente;
        $op->id_producto = $request->id_producto;
        $op->cantidad = $request->cantidad;
        $op->lista_materiales = $request->lista_materiales;
        $op->condiciones_entrega = $request->condiciones_entrega;
        // $op->fecha_prevista = date("Y-m-d", strtotime($request->fecha_prevista));
        $op->id_cotizacion = $request->id_cotizacion;
        $op->id_cotizacion_producto = $request->id_cotizacion_producto;
        $op->lugar_entrega = $request->lugar_entrega;
        $op->fecha_prevista = $request->fecha_entrega_planificada;
        $op->numero_oc = $request->numero_oc;
        $op->micras = $request->tipo_producto;
        $op->lista_materiales = $request->tipo_tela;
        $op->diseno_prenda = $request->diseno_prenda;
        $op->caracteristicas = $request->detalle_etnico;
        $op->observaciones = $request->notas_importantes;
        $op->status = 2;
        $op->inventario = $request->inventario;
        $op->update();

        // Crear o actualizar el detalle de la orden de producción
        $opDetalle = OrdenProduccionDetalle::updateOrCreate(
            ['orden_produccion_id' => $op->id],
            [
                'genero' => $request->genero_prenda,
                'talla' => $request->talla_prenda,
                'personalizacion' => $request->personalizacion_prenda,
                'bordados' => $request->bordado_prenda,
                'serigrafia' => $request->serigrafia_prenda,
                'sublimacion' => $request->sublimacion_prenda,
                'color' => $request->color_prenda,
            ]
        );

        // Manejo de archivos para logos
        $logos = $opDetalle->logos_prenda ?? [];
        if ($request->hasFile('logos_prenda')) {
            foreach ($request->file('logos_prenda') as $file) {
                $randomName = Str::random(10) . '.' . $file->getClientOriginalExtension();
                $path = $file->storeAs('public/orden_produccion/logos', $randomName);
                $logos[] = $randomName;
            }
        }
        $opDetalle->logos_prenda = $logos;

        // Manejo de archivos para ilustraciones
        $ilustraciones = $opDetalle->ilustraciones_prenda ?? [];
        if ($request->hasFile('referencia_prenda')) {
            foreach ($request->file('referencia_prenda') as $file) {
                $randomName = Str::random(10) . '.' . $file->getClientOriginalExtension();
                $path = $file->storeAs('public/orden_produccion/ilustraciones', $randomName);
                $ilustraciones[] = $randomName;
            }
        }
        $opDetalle->ilustraciones_prenda = $ilustraciones;

        // Guardar los cambios en OrdenProduccionDetalle
        $opDetalle->save();


        if ($request->id_cotizacion != 999999) {
            $cotizacion_producto = CotizacionProductos::where('id', $request->id_cotizacion_producto)->first();
            $cotizacion_producto->estatus = 4;
            $cotizacion_producto->update();
        }
        // //Envio de correo
        // $cliente = Cliente::where('id', $request->id_cliente)->with('info_ejecutivo')->first();
        // $correo_ejecutivo = $cliente->info_ejecutivo->email ?? '';
        // $idOP = $op->id;
        //Enviar correo
        // Mail::send('email.op_ok', compact('op'), function ($message) use ($idOP, $correo_ejecutivo) {
        //     $message->from('info@laravelrp.com', 'Concisa OP ' . $idOP);
        //     $message->to('kicas48@gmail.com');
        //     $message->to('anylopeza3@gmail.com');
        //     $message->to('danny.concisa@gmail.com');
        //     if ($correo_ejecutivo) {
        //         $message->to($correo_ejecutivo);
        //     }
        //     $message->subject('OP Autorizada - OP' . $idOP);
        // });

        $arrResponse = [
            'message' => 'Orde de Producción creada correctamente'
        ];
        return redirect()->route('ventas.dashboard_produccion_gerencia')->with($arrResponse);
    }

    public function actualizarOkOP2(Request $request, OrdenProduccion $op)
    {
        // Actualizar los campos de OrdenProduccion
        $op->id_usuario = Auth::id();
        $op->id_cliente = $request->id_cliente;
        $op->id_producto = $request->id_producto;
        $op->cantidad = $request->cantidad;
        $op->lista_materiales = $request->lista_materiales;
        $op->condiciones_entrega = $request->condiciones_entrega;
        $op->id_cotizacion = $request->id_cotizacion;
        $op->id_cotizacion_producto = $request->id_cotizacion_producto;
        $op->lugar_entrega = $request->lugar_entrega;
        $op->fecha_prevista = $request->fecha_entrega_planificada;
        $op->numero_oc = $request->numero_oc;
        $op->micras = $request->tipo_producto;
        $op->lista_materiales = $request->tipo_tela;
        $op->diseno_prenda = $request->diseno_prenda;
        $op->caracteristicas = $request->detalle_etnico;
        $op->observaciones = $request->notas_importantes;
        $op->status = 2;
        $op->inventario = $request->inventario;
        $op->comentario_ing = $request->comentario_ing;
        $op->update();

        // Crear o actualizar el detalle de la orden de producción
        $opDetalle = OrdenProduccionDetalle::updateOrCreate(
            ['orden_produccion_id' => $op->id],
            [
                'genero' => $request->genero_prenda,
                'talla' => $request->talla_prenda,
                'personalizacion' => $request->personalizacion_prenda,
                'bordados' => $request->bordado_prenda,
                'serigrafia' => $request->serigrafia_prenda,
                'sublimacion' => $request->sublimacion_prenda,
                'color' => $request->color_prenda,
            ]
        );

        // Manejo de archivos para logos
        $logos = $opDetalle->logos_prenda ?? [];
        if ($request->hasFile('logos_prenda')) {
            foreach ($request->file('logos_prenda') as $file) {
                $randomName = Str::random(10) . '.' . $file->getClientOriginalExtension();
                $path = $file->storeAs('public/orden_produccion/logos', $randomName);
                $logos[] = $randomName;
            }
        }
        $opDetalle->logos_prenda = $logos;

        // Manejo de archivos para ilustraciones
        $ilustraciones = $opDetalle->ilustraciones_prenda ?? [];
        if ($request->hasFile('referencia_prenda')) {
            foreach ($request->file('referencia_prenda') as $file) {
                $randomName = Str::random(10) . '.' . $file->getClientOriginalExtension();
                $path = $file->storeAs('public/orden_produccion/ilustraciones', $randomName);
                $ilustraciones[] = $randomName;
            }
        }
        $opDetalle->ilustraciones_prenda = $ilustraciones;

        // Guardar los cambios en OrdenProduccionDetalle
        $opDetalle->save();

        // Enviar notificación por correo
        // Mail::send('email.op_cambios', compact('comentario_ing'), function ($message) use ($opId) {
        //     $message->from('info@laravelrp.com', 'Concisa - Cambios OP' . $opId);
        //     $message->to('kicas48@gmail.com');
        //     $message->to('anylopeza3@gmail.com');
        //     $message->to('danny.concisa@gmail.com');
        //     $message->subject('Cambios en Orden de Producción - OP' . $opId);
        // });

        // Envío de respuesta y redireccionamiento
        $arrResponse = [
            'message' => 'Orden de Producción actualizada correctamente'
        ];
        return redirect()->route('ventas.dashboard_produccion_gerencia')->with($arrResponse);
    }

    public function verOP($idOrden)
    {
        //    
        $opParciales = OrdenProduccionParcial::where('id_op', $idOrden)->with('op')->get();
        $op = OrdenProduccion::where('id', $idOrden)->with('cliente')->with('producto')->first();
        $detalleOrden = $op->detalle;
        return view('ventas.orden_produccion_ver', compact('op', 'opParciales', 'detalleOrden'));
    }

    public function ordenProduccionPdf($idOrden)
    {
        $op = OrdenProduccion::where('id', $idOrden)->first();
        $ilustracionesURL = public_path('storage/orden_produccion/ilustraciones');
        $logosURL = public_path('storage/orden_produccion/logos');
        $pdf = PDF::loadView('ventas.pdf.orden_produccion', compact('op', 'ilustracionesURL', 'logosURL'));
        $timestamp = date('d-m-Y');
        return $pdf->download($timestamp . '_orden_produccion_' . $idOrden . '.pdf');
        // return view('ventas.pdf.orden_produccion', compact('op', 'ilustracionesURL', 'logosURL'));
    }
}
