<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Compra extends Model
{
    use SoftDeletes;

    public function proveedor()
    {
        return $this->belongsTo(Proveedor::class);
    }

    public function detalle()
    {
        return $this->hasMany(CompraProducto::class);
    }

    public function pagos()
    {
        return $this->hasMany(CompraPago::class)->orderBy('created_at', 'desc');
    }

    public function envio()
    {
        return $this->hasMany(CompraEnvio::class)->orderBy('created_at', 'desc');
    }
}
